% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{StabilityMetrics}
\alias{StabilityMetrics}
\title{Stability selection metrics}
\usage{
StabilityMetrics(
  selprop,
  pk = NULL,
  pi_list = seq(0.6, 0.9, by = 0.01),
  K = 100,
  n_cat = 3,
  PFER_method = "MB",
  PFER_thr_blocks = Inf,
  FDP_thr_blocks = Inf,
  Sequential_template = NULL,
  graph = TRUE,
  group = NULL
)
}
\arguments{
\item{selprop}{array of selection proportions.}

\item{pk}{optional vector encoding the grouping structure. Only used for
multi-block stability selection where \code{pk} indicates the number of
variables in each group. If \code{pk=NULL}, single-block stability
selection is performed.}

\item{pi_list}{vector of thresholds in selection proportions. If
\code{n_cat=3}, these values must be \code{>0.5} and \code{<1}. If
\code{n_cat=2}, these values must be \code{>0} and \code{<1}.}

\item{K}{number of resampling iterations.}

\item{n_cat}{number of categories used to compute the stability score.
Possible values are 2 or 3.}

\item{PFER_method}{method used to compute the upper-bound of the expected
number of False Positives (or Per Family Error Rate, PFER). If
\code{PFER_method="MB"}, the method proposed by Meinshausen and Bühlmann
(2010) is used. If \code{PFER_method="SS"}, the method proposed by Shah and
Samworth (2013) under the assumption of unimodality is used.}

\item{PFER_thr_blocks}{vector of block-specific thresholds in PFER for
constrained calibration by error control. If \code{PFER_thr=Inf} and
\code{FDP_thr=Inf}, unconstrained calibration is used.}

\item{FDP_thr_blocks}{vector of block-specific thresholds in the expected
proportion of falsely selected features (or False Discovery Proportion,
FDP) for constrained calibration by error control. If \code{PFER_thr=Inf}
and \code{FDP_thr=Inf}, unconstrained calibration is used.}

\item{Sequential_template}{logical matrix encoding the type of procedure to
use for data with multiple blocks in stability selection graphical
modelling. For multi-block estimation, the stability selection model is
constructed as the union of block-specific stable edges estimated while the
others are weakly penalised (\code{TRUE} only for the block currently being
calibrated and \code{FALSE} for other blocks). Other approaches with joint
calibration of the blocks are allowed (all entries are set to \code{TRUE}).}

\item{graph}{logical indicating if stability selection is performed in a
regression (if \code{FALSE}) or graphical (if \code{TRUE})
framework.}

\item{group}{vector encoding the grouping structure among predictors. This
argument indicates the number of variables in each group and only needs to
be provided for group (but not sparse group) penalisation.}
}
\value{
A list with: \item{S}{a matrix of the best (block-specific) stability
  scores for different (sets of) penalty parameters. In multi-block stability
  selection, rows correspond to different sets of penalty parameters, (values
  are stored in the output "Lambda") and columns correspond to different
  blocks.} \item{Lambda}{a matrix of (block-specific) penalty parameters. In
  multi-block stability selection, rows correspond to sets of penalty
  parameters and columns correspond to different blocks.} \item{Q}{a matrix
  of average numbers of (block-specific) edges selected by the underlying
  algorithm for different (sets of) penalty parameters. In multi-block
  stability selection, rows correspond to different sets of penalty
  parameters, (values are stored in the output "Lambda") and columns
  correspond to different blocks.} \item{Q_s}{a matrix of calibrated numbers
  of (block-specific) stable edges for different (sets of) penalty
  parameters. In multi-block stability selection, rows correspond to
  different sets of penalty parameters, (values are stored in the output
  "Lambda") and columns correspond to different blocks.} \item{P}{a matrix of
  calibrated (block-specific) thresholds in selection proportions for
  different (sets of) penalty parameters. In multi-block stability selection,
  rows correspond to different sets of penalty parameters, (values are stored
  in the output "Lambda") and columns correspond to different blocks.}
  \item{PFER}{a matrix of computed (block-specific) upper-bounds in PFER of
  calibrated graphs for different (sets of) penalty parameters. In
  multi-block stability selection, rows correspond to different sets of
  penalty parameters, (values are stored in the output "Lambda") and columns
  correspond to different blocks.} \item{FDP}{a matrix of computed
  (block-specific) upper-bounds in FDP of calibrated stability selection
  models for different (sets of) penalty parameters. In multi-block stability
  selection, rows correspond to different sets of penalty parameters, (values
  are stored in the output "Lambda") and columns correspond to different
  blocks.} \item{S_2d}{an array of (block-specific) stability scores obtained
  with different combinations of parameters. Rows correspond to different
  (sets of) penalty parameters and columns correspond to different thresholds
  in selection proportions. In multi-block stability selection, indices along
  the third dimension correspond to different blocks.} \item{PFER_2d}{an
  array of computed upper-bounds of PFER obtained with different combinations
  of parameters. Rows correspond to different penalty parameters and columns
  correspond to different thresholds in selection proportions. Not available
  in multi-block stability selection graphical modelling.} \item{FDP_2d}{an
  array of computed upper-bounds of FDP obtained with different combinations
  of parameters. Rows correspond to different penalty parameters and columns
  correspond to different thresholds in selection proportions. Not available
  in multi-block stability selection graphical modelling.}
}
\description{
Computes the stability score (see \code{\link{StabilityScore}}) and
upper-bounds of the \code{\link{PFER}} and \code{\link{FDP}} from selection
proportions of models with a given parameter controlling the sparsity of the
underlying algorithm and for different thresholds in selection proportions.
}
\examples{
## Sparse or sparse group penalisation

# Simulating set of selection proportions
set.seed(1)
selprop <- matrix(round(runif(n = 20), digits = 2), nrow = 2)

# Computing stability scores for different thresholds
metrics <- StabilityMetrics(
  selprop = selprop, pi = c(0.6, 0.7, 0.8),
  K = 100, graph = FALSE
)


## Group penalisation

# Simulating set of selection proportions
set.seed(1)
selprop <- matrix(round(runif(n = 6), digits = 2), nrow = 2)
selprop <- cbind(
  selprop[, 1], selprop[, 1],
  selprop[, 2], selprop[, 2],
  matrix(rep(selprop[, 3], each = 6), nrow = 2, byrow = TRUE)
)

# Computing stability scores for different thresholds
metrics <- StabilityMetrics(
  selprop = selprop, pi = c(0.6, 0.7, 0.8),
  K = 100, graph = FALSE, group = c(2, 2, 6)
)
}
\references{
\insertRef{ourstabilityselection}{sharp}

  \insertRef{stabilityselectionMB}{sharp}

  \insertRef{stabilityselectionSS}{sharp}
}
\seealso{
Other stability metric functions: 
\code{\link{ConsensusScore}()},
\code{\link{FDP}()},
\code{\link{PFER}()},
\code{\link{StabilityScore}()}
}
\concept{stability metric functions}
