% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizGeomorphicComponent.R
\name{vizGeomorphicComponent}
\alias{vizGeomorphicComponent}
\title{Visual Summary of Hill Landform Positions}
\usage{
vizGeomorphicComponent(x, s = NULL, annotations = TRUE, annotation.cex = 0.75)
}
\arguments{
\item{x}{\code{data.frame} as created by \code{soilDB::fetchOSD(..., extended=TRUE)}, see details}

\item{s}{an optional soil series name, highlighted in the figure}

\item{annotations}{logical, add number of record and normalized Shannon entropy values}

\item{annotation.cex}{annotation label scaling factor}
}
\value{
A \code{list} with the following elements:
\itemize{
\item \code{fig}: lattice object (the figure)
\item \code{order}: 1D ordering from \code{cluster::diana}
\item \code{clust}: clustering object returned by \code{cluster::diana}
}
}
\description{
A unique display of landform position probability.
}
\details{
See the \href{http://ncss-tech.github.io/AQP/soilDB/soil-series-query-functions.html}{Soil Series Query Functions} tutorial for more information.
}
\author{
D.E. Beaudette
}
