% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareDailyClimateData.R
\name{prepareDailyClimateData}
\alias{prepareDailyClimateData}
\title{Prepare daily climate data (DAYMET) for a single point}
\usage{
prepareDailyClimateData(x, start, end, onlyWB = TRUE)
}
\arguments{
\item{x}{\code{sf} object representing a single point}

\item{start}{start year (1998)}

\item{end}{end year (2018)}

\item{onlyWB}{logical, return just those date required by \code{dailyWB}}
}
\value{
a \code{data.frame}
}
\description{
This function returns daily climate data required for a simple water balance (and more), using three packages:
\itemize{
\item \code{elevatr}: elevation data at \code{x}
\item \code{daymetr}: DAYMET data at \code{x} for years \code{start} through \code{end}
\item \code{Evapotranspiration}: Makkink formulation for estimating reference crop evapotranspiration
}
}
