% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/examples.R
\name{Link}
\alias{Link}
\title{Link}
\usage{
Link(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
Links lead to another part of an app, other pages, or help articles. They can also be used to initiate commands.

For more details and examples visit the \href{https://developer.microsoft.com/en-us/fluentui#/controls/web/Link}{official docs}.
The R package cannot handle each and every case, so for advanced use cases
you need to work using the original docs to achieve the desired result.
}
\details{
\itemize{
\item {\bold{ as }} {\code{string | React.ComponentClass | React.FunctionComponent} \cr A component that should be used as the root element of the link returned from the Link component.}
\item {\bold{ componentRef }} {\verb{IRefObject<ILink>} \cr Optional callback to access the ILink interface. Use this instead of ref for accessing the public methods and properties of the component.}
\item {\bold{ disabled }} {\code{boolean} \cr Whether the link is disabled}
\item {\bold{ keytipProps }} {\code{IKeytipProps} \cr Optional keytip for this Link}
\item {\bold{ styles }} {\verb{IStyleFunctionOrObject<ILinkStyleProps, ILinkStyles>} \cr Call to provide customized styling that will layer on top of the variant rules.}
\item {\bold{ theme }} {\code{ITheme} \cr Theme (provided through customization.)}
}
}
\section{Best practices}{
\subsection{Layout}{
\itemize{
\item Links visually indicate that they can be clicked, typically by being displayed using the visited or unvisited link system colors. Traditionally, links are underlined as well, but that approach is often reserved for body copy links within an article.
}
}

\subsection{Content}{
\itemize{
\item People should be able to accurately predict the result of selecting a link based on its link text and optional tooltip.
\item Use descriptive, actionable link text when possible. Avoid using URLs as link text.
\item Don't use if the action is destructive or irreversible. Links aren't appropriate for commands with significant consequences.
\item Keep discrete links far enough apart that people can differentiate between them and easily select each one.
\item Use sentence-style capitalization—only capitalize the first word. For more info, see \href{https://docs.microsoft.com/style-guide/capitalization}{Capitalization} in the Microsoft Writing Style Guide.
}
}
}

\examples{
library(shiny.fluent)

if (interactive()) {
  shinyApp(
    ui = Link(href = "https://appsilon.com", "Appsilon"),
    server = function(input, output) {}
  )
}
}
