% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{tabPanel}
\alias{tabPanel}
\title{Create a tab panel}
\usage{
tabPanel(title, ..., value = title, icon = NULL)
}
\arguments{
\item{title}{Display title for tab}

\item{...}{UI elements to include within the tab}

\item{value}{The value that should be sent when \code{tabsetPanel} reports
that this tab is selected. If omitted and \code{tabsetPanel} has an
\code{id}, then the title will be used..}

\item{icon}{Optional icon to appear on the tab. This attribute is only
valid when using a \code{tabPanel} within a \code{\link{navbarPage}}.}
}
\value{
A tab that can be passed to \code{\link{tabsetPanel}}
}
\description{
Create a tab panel that can be included within a \code{\link{tabsetPanel}}.
}
\examples{
# Show a tabset that includes a plot, summary, and
# table view of the generated distribution
mainPanel(
  tabsetPanel(
    tabPanel("Plot", plotOutput("plot")),
    tabPanel("Summary", verbatimTextOutput("summary")),
    tabPanel("Table", tableOutput("table"))
  )
)
}
\seealso{
\code{\link{tabsetPanel}}
}
