% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakraSlider.R
\name{chakraSlider}
\alias{chakraSlider}
\title{Chakra slider}
\usage{
chakraSlider(
  id,
  label = NULL,
  value,
  min,
  max,
  step = NULL,
  width = NULL,
  size = "md",
  colorScheme = "blue",
  orientation = "horizontal",
  focusThumbOnChange = TRUE,
  isDisabled = FALSE,
  isReadOnly = FALSE,
  isReversed = FALSE,
  trackColor = NULL,
  filledTrackColor = NULL,
  mark = FALSE,
  markOptions = sliderMarkOptions(),
  tooltip = TRUE,
  tooltipOptions = sliderTooltipOptions(),
  thumbOptions = sliderThumbOptions(),
  shinyValueOn = "end",
  ...
)
}
\arguments{
\item{id}{widget id}

\item{label}{label (optional)}

\item{value}{initial value}

\item{min}{minimal value}

\item{max}{maximal value}

\item{step}{increment step}

\item{width}{slider width}

\item{size}{size, \code{"sm"}, \code{"md"}, or \code{"lg"}}

\item{colorScheme}{a Chakra color scheme}

\item{orientation}{slider orientation, \code{"horizontal"} or
\code{"vertical"}}

\item{focusThumbOnChange}{whether to focus the thumb on change}

\item{isDisabled}{whether to disable the slider}

\item{isReadOnly}{read only mode}

\item{isReversed}{whether to reverse the slider}

\item{trackColor}{color of the track}

\item{filledTrackColor}{color of the filled track}

\item{mark}{whether to set a mark to the thumb
(I personally prefer the tooltip)}

\item{markOptions}{options of the mark, a list created with
\code{\link{sliderMarkOptions}}}

\item{tooltip}{whether to set a tooltip to the thumb}

\item{tooltipOptions}{options of the tooltip, a list created with
\code{\link{sliderTooltipOptions}}}

\item{thumbOptions}{list of options for the thumb created with
\code{\link{sliderThumbOptions}}}

\item{shinyValueOn}{either \code{"drag"} or \code{"end"}, the moment to get
the Shiny value}

\item{...}{other attributes passed to \code{Slider}}
}
\value{
A widget to use in \code{\link{chakraComponent}}.
}
\description{
Create a Chakra slider.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    chakraSlider(
      "slider",
      label = HTML("<span style='color:red'>Hello slider!</span>"),
      value = 5,
      min = 0,
      max = 10,
      width = "50\%",
      tooltip = TRUE,
      shinyValueOn = "end"
    )

  )

)

server <- function(input, output, session){

  observe({
    print(input[["slider"]])
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
