% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uiModal.R
\name{modalDialogUI}
\alias{modalDialogUI}
\alias{modalButtonUI}
\title{Create modal in UI application part}
\usage{
modalDialogUI(
  modalId,
  ...,
  button = modalButtonUI(modalId, "Open Modal"),
  title = NULL,
  footer = shiny::modalButton("Dismiss"),
  size = c("m", "s", "l", "xl"),
  easyClose = FALSE,
  fade = TRUE,
  backdrop = TRUE
)

modalButtonUI(modalId, label, icon = NULL, width = NULL, ...)
}
\arguments{
\item{modalId}{Id of the modal.}

\item{...}{Additional properties added to button.}

\item{button}{Visible button placed in modal DOM structure, responsible for opening it.
Set `NULL` to have no button included.}

\item{title}{An optional title for the modal dialog.}

\item{footer}{UI for modal dialog footer.}

\item{size}{of the modal dialog. Can be "s", "m" (default), "l" or "xl".}

\item{easyClose}{Set `TRUE` to enable closing modal with clicking outside it.}

\item{fade}{Should fade-in animation be turned on?}

\item{backdrop}{Set `FALSE` to turn on background covering area outside modal dialog.}

\item{label}{Modal button label.}

\item{icon}{Modal button icon.}

\item{width}{Button width.}
}
\value{
Nested list of `shiny.tag` objects defining html structure of modal dialog,
  or single `shiny.tag` object in case of using `modalButtonUI` method.
}
\description{
Contrary to \link[shiny]{modalDialog} the function allows to define modal in
UI application structure.
The modal can be opened with `modalButtonUI` placed anywhere in the application.
}
\examples{
if (interactive()) {
  library(shiny)
  shinyApp(
    ui = fluidPage(
      modalDialogUI("mdl", "Hello")
    ),
    server = function(input, output, session) {}
  )

  library(shiny)
  shinyApp(
    ui = fluidPage(
      modalDialogUI("mdl", "Hello", button = NULL),
      hr(),
      modalButtonUI("mdl", "Open Modal From Here")
    ),
    server = function(input, output, session) {}
  )
}

}
