% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7CheckboxGroup}
\alias{f7CheckboxGroup}
\title{Framework7 checkbox group}
\usage{
f7CheckboxGroup(inputId, label, choices = NULL, selected = NULL)
}
\arguments{
\item{inputId}{Checkbox group input.}

\item{label}{Checkbox group label.}

\item{choices}{Checkbox group choices.}

\item{selected}{Checkbox group selected value.}
}
\description{
\code{f7CheckboxGroup} creates a checkbox group input
}
\examples{
if(interactive()){
  library(shiny)
  library(shinyMobile)

  shiny::shinyApp(
    ui = f7Page(
     title = "My app",
     f7SingleLayout(
      navbar = f7Navbar(title = "f7CheckboxGroup"),
      f7CheckboxGroup(
       inputId = "variable",
       label = "Choose a variable:",
       choices = colnames(mtcars)[-1],
       selected = NULL
      ),
      tableOutput("data")
     )
    ),
    server = function(input, output) {
     output$data <- renderTable({
      mtcars[, c("mpg", input$variable), drop = FALSE]
      }, rownames = TRUE)
    }
  )
 }
}
