% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-validate-inputs.R
\name{validateF7Input}
\alias{validateF7Input}
\title{Framework7 input validation}
\usage{
validateF7Input(
  inputId,
  info = NULL,
  pattern = NULL,
  error = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{Input to validate.}

\item{info}{Additional text to display below the input field.}

\item{pattern}{Pattern for validation. Regex.}

\item{error}{Error text.}

\item{session}{Shiny session object.}
}
\description{
\code{validateF7Input} is a function to validate a given shinyMobile input.
}
\note{
Only works for \link{f7Text}, \link{f7Password}, \link{f7TextArea} and \link{f7Select}.
See more at \url{https://framework7.io/docs/inputs.html}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "Validate inputs",
     f7SingleLayout(
       navbar = f7Navbar(title = "validateF7Input"),
       f7Text(
         inputId = "caption",
         label = "Caption",
         value = "Data Summary"
       ),
       verbatimTextOutput("value"),
       hr(),
       f7Text(
         inputId = "caption2",
         label = "Enter a number",
         value = 1
       )
     )
   ),
   server = function(input, output, session) {
     observe({
       validateF7Input(inputId = "caption", info = "Whatever")
       validateF7Input(
         inputId = "caption2",
         pattern = "[0-9]*",
         error = "Only numbers please!"
       )
     })
     output$value <- renderPrint({ input$caption })
   }
 )
}
}
