% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-checkboxgroupbuttons.R
\name{checkboxGroupButtons}
\alias{checkboxGroupButtons}
\title{Buttons Group checkbox Input Control}
\usage{
checkboxGroupButtons(inputId, label = NULL, choices = NULL,
  selected = NULL, status = "default", size = "normal",
  direction = "horizontal", justified = FALSE, individual = FALSE,
  checkIcon = list(), width = NULL, choiceNames = NULL,
  choiceValues = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Input label.}

\item{choices}{List of values to select from (if elements of the list are named
then that name rather than the value is displayed to the user)}

\item{selected}{The initially selected value.}

\item{status}{Add a class to the buttons, you can use Bootstrap status like 'info', 'primary', 'danger', 'warning' or 'success'.
Or use an arbitrary strings to add a custom class, e.g. : with \code{status = 'myClass'}, buttons will have class \code{btn-myClass}.}

\item{size}{Size of the buttons ('xs', 'sm', 'normal', 'lg')}

\item{direction}{Horizontal or vertical.}

\item{justified}{If TRUE, fill the width of the parent div.}

\item{individual}{If TRUE, buttons are separated.}

\item{checkIcon}{A list, if no empty must contain at least one element named 'yes'
corresponding to an icon to display if the button is checked.}

\item{width}{The width of the input, e.g. '400px', or '100\%'.}

\item{choiceNames, choiceValues}{Same as in \code{\link[shiny]{checkboxGroupInput}}. List of names and values, respectively, that are displayed to
the user in the app and correspond to the each choice (for this reason,
\code{choiceNames} and \code{choiceValues} must have the same length).}
}
\value{
A buttons group control that can be added to a UI definition.
}
\description{
Create buttons grouped that act like checkboxes.
}
\examples{
if (interactive()) {

  ui <- fluidPage(
    tags$h1("checkboxGroupButtons examples"),

    checkboxGroupButtons(
      inputId = "somevalue1",
      label = "Make a choice: ",
      choices = c("A", "B", "C")
    ),
    verbatimTextOutput("value1"),

    checkboxGroupButtons(
      inputId = "somevalue2",
      label = "With custom status:",
      choices = names(iris),
      status = "primary"
    ),
    verbatimTextOutput("value2"),

    checkboxGroupButtons(
      inputId = "somevalue3",
      label = "With icons:",
      choices = names(mtcars),
      checkIcon = list(
        yes = icon("check-square"),
        no = icon("square-o")
      )
    ),
    verbatimTextOutput("value3")
  )
  server <- function(input, output) {

    output$value1 <- renderPrint({ input$somevalue1 })
    output$value2 <- renderPrint({ input$somevalue2 })
    output$value3 <- renderPrint({ input$somevalue3 })

  }
  shinyApp(ui, server)

}
}
\seealso{
\code{\link{updateCheckboxGroupButtons}}
}
