% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-noUiSlider.R
\name{wNumbFormat}
\alias{wNumbFormat}
\title{Format numbers in noUiSliderInput}
\usage{
wNumbFormat(
  decimals = NULL,
  mark = NULL,
  thousand = NULL,
  prefix = NULL,
  suffix = NULL,
  negative = NULL
)
}
\arguments{
\item{decimals}{The number of decimals to include in
the result. Limited to 7.}

\item{mark}{The decimal separator. Defaults to \code{'.'}
if thousand isn't already set to \code{'.'}.}

\item{thousand}{Separator for large numbers. For example: \code{' '}
would result in a formatted number of 1 000 000.}

\item{prefix}{A string to prepend to the number. Use cases
include prefixing with money symbols such as \code{'$'} or \code{'€'}.}

\item{suffix}{A number to append to a number. For example: \code{',-'}.}

\item{negative}{The prefix for negative values. Defaults to \code{'-'}.}
}
\value{
a named list.
}
\description{
Format numbers in noUiSliderInput
}
\note{
Performed via wNumb JavaScript library : \url{https://refreshless.com/wnumb/}.
}
\examples{
if (interactive()) {

library( shiny )
library( shinyWidgets )

ui <- fluidPage(
  tags$h3("Format numbers"),
  tags$br(),

  noUiSliderInput(
    inputId = "form1",
    min = 0, max = 10000,
    value = 800,
    format = wNumbFormat(decimals = 3,
                         thousand = ".",
                         suffix = " (US $)")
  ),
  verbatimTextOutput(outputId = "res1"),

  tags$br(),

  noUiSliderInput(
    inputId = "form2",
    min = 1988, max = 2018,
    value = 1988,
    format = wNumbFormat(decimals = 0,
                         thousand = "",
                         prefix = "Year: ")
  ),
  verbatimTextOutput(outputId = "res2"),

  tags$br()

)

server <- function(input, output, session) {

  output$res1 <- renderPrint(input$form1)
  output$res2 <- renderPrint(input$form2)

}

shinyApp(ui, server)

}
}
