% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-icon.R
\name{updateNumericInputIcon}
\alias{updateNumericInputIcon}
\title{Change the value of a numeric input icon on the client}
\usage{
updateNumericInputIcon(
  session,
  inputId,
  label = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  step = NULL,
  icon = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{min}{Minimum value.}

\item{max}{Maximum value.}

\item{step}{Step size.}

\item{icon}{Icon to update, note that you can update icon only
if initialized in \code{\link{numericInputIcon}}.}
}
\value{
No value.
}
\description{
Change the value of a numeric input icon on the client
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  numericInputIcon(
    inputId = "id",
    label = "With an icon",
    value = 10,
    icon = icon("percent")
  ),
  actionButton("updateValue", "Update value"),
  actionButton("updateIcon", "Update icon"),
  verbatimTextOutput("value")
)

server <- function(input, output, session) {

  output$value <- renderPrint(input$id)

  observeEvent(input$updateValue, {
    updateNumericInputIcon(
      session = session,
      inputId = "id",
      value = sample.int(100, 1)
    )
  })

  observeEvent(input$updateIcon, {
    i <- sample(c("home", "gears", "dollar", "globe", "sliders"), 1)
    updateNumericInputIcon(
      session = session,
      inputId = "id",
      icon = icon(i)
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
