% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxes.R
\name{boxSidebar}
\alias{boxSidebar}
\alias{updateBoxSidebar}
\title{Create a sidebar for a box}
\usage{
boxSidebar(
  ...,
  id = NULL,
  width = 50,
  background = "#333a40",
  startOpen = FALSE,
  icon = shiny::icon("cogs")
)

updateBoxSidebar(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{...}{Sidebar content.}

\item{id}{Sidebar id.}

\item{width}{Sidebar opening width in percentage. 50\% by default, 
means the card sidebar will take 50% of the card width, when opened. 
A numeric value between 25 and 100.}

\item{background}{Sidebar background color. Dark by default. Expect a HEX code.}

\item{startOpen}{Whether the sidebar is open at start. FALSE by default.}

\item{icon}{Sidebar icon. Expect \code{\link[shiny]{icon}}.}

\item{session}{Shiny session object.}
}
\description{
\link{boxSidebar} is inserted in the sidebar slot of \link{box}.

\link{updateBoxSidebar} toggle a \link{boxSidebar} on the client.
}
\examples{

# Toggle a box sidebar
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 library(shinydashboardPlus)
 
 shinyApp(
  ui = dashboardPage(
    header = dashboardHeader(),
    body = dashboardBody(
      box(
        title = "Update box sidebar", 
        closable = TRUE, 
        width = 12,
        height = "500px",
        solidHeader = FALSE, 
        collapsible = TRUE,
        actionButton("update", "Toggle card sidebar"),
        sidebar = boxSidebar(
          id = "mycardsidebar",
          p("Sidebar Content")
        )
      )
    ),
    sidebar = dashboardSidebar()
  ),
  server = function(input, output, session) {
    observe(print(input$mycardsidebar))
    
    observeEvent(input$update, {
      updateBoxSidebar("mycardsidebar")
    })
    
  }
 )
}
}
