% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{Class_effects}
\alias{Class_effects}
\alias{jqui_add_class}
\alias{jqui_remove_class}
\alias{jqui_switch_class}
\title{Class effects.}
\usage{
jqui_add_class(
  ui,
  className,
  duration = 400,
  easing = "swing",
  complete = NULL
)

jqui_remove_class(
  ui,
  className,
  duration = 400,
  easing = "swing",
  complete = NULL
)

jqui_switch_class(
  ui,
  removeClassName,
  addClassName,
  duration = 400,
  easing = "swing",
  complete = NULL
)
}
\arguments{
\item{ui}{The target ui element(s) to be manipulated. Can be
\itemize{
\item A string of \href{https://api.jquery.com/category/selectors/}{jQuery_selector}
\item A \link[htmlwidgets:JS]{JS()} wrapped javascript expression that returns a
\href{https://api.jquery.com/Types/}{jQuery object}.
}}

\item{className}{One or more class names (space separated) to be added to or
removed from the class attribute of each matched element.}

\item{duration}{A string or number determining how long the animation will
run.}

\item{easing}{A string indicating which
\href{https://api.jqueryui.com/easings/}{easing} function to use for the
transition.}

\item{complete}{A js function to call once the animation is complete, called
once per matched element.}

\item{removeClassName}{One or more class names (space separated) to be
removed from the class attribute of each matched element.}

\item{addClassName}{One or more class names (space separated) to be added to
the class attribute of each matched element.}
}
\description{
Manipulate specified class(es) to matched elements while animating all style
changes.
\itemize{
\item \code{jqui_add_class()}: Add class(es).
\item \code{jqui_remove_class()}: Remove class(es).
\item \code{jqui_switch_class()}: Switch class(es).
}
}
\details{
These functions are the R wrappers of
\href{https://api.jqueryui.com/addClass/}{addClass()},
\href{https://api.jqueryui.com/removeClass/}{removeClass()} and
\href{https://api.jqueryui.com/switchClass/}{switchClass()} from jQuery UI library.
They should be used in \code{server} of a shiny app.
}
\examples{
\dontrun{
  # in shiny ui create a span
  tags$span(id = 'foo', 'class animation demo')

  # in shiny server add class 'lead' to the span
  jqui_add_class('#foo', className = 'lead')
}
}
