% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{metadata}
\alias{metadata}
\title{Add metadata lines to modules}
\usage{
metadata(folder_path, module = NULL)
}
\arguments{
\item{folder_path}{character. Path to the parent directory containing the application}

\item{module}{character. (optional) Name of a single module to edit}
}
\value{
No return value, called for side effects
}
\description{
Adds lines to modules and their associated rmarkdown files to
semi-automate reproducibility. By default all the modules in the application
are edited or you can specify a single module. If metadata lines are already
present, the file will not be edited. This function is currently experimental
and only semi-automates the process. To ensure that the code is functional
complete the following steps:
\itemize{
\item Check that any inputs created by packages other than 'shiny' are included
\item Add any inputs created dynamically i.e. those without an explicit
line of code to generate them, for example those created inside a loop in a
\code{renderUI} or from a 'leaflet' or 'DT' object.
\item Use the objects in each \code{.Rmd} file to call the module's function.
}
}
\examples{
td <- tempfile()
dir.create(td, recursive = TRUE)

modules <- data.frame(
  "component" = c("demo"),
  "long_component" = c("demo"),
  "module" = c("demo"),
  "long_module" = c("demo"),
  "map" = c(FALSE),
  "result" = c(TRUE),
  "rmd" = c(TRUE),
  "save" = c(TRUE),
  "download" = c(TRUE),
  "async" = c(FALSE))

create_template(path = td, name = "demo",
                common_objects = c("demo"), modules = modules,
                author = "demo", include_map = FALSE,
                include_table = FALSE, include_code = FALSE, install = FALSE)

test_files <- list.files(
  system.file("extdata", package = "shinyscholar"),
  pattern = "test_test*", full.names = TRUE)

module_directory <- file.path(td, "demo", "inst", "shiny", "modules")
file.copy(test_files, module_directory, overwrite = TRUE)

metadata(file.path(td, "demo"), module = "test_test")

}
\author{
Simon E. H. Smart \href{mailto:simon.smart@cantab.net}{simon.smart@cantab.net}
}
