% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view-diff.R
\name{viewTestDiff}
\alias{viewTestDiff}
\title{View differences in test results}
\usage{
viewTestDiff(appDir = ".", testnames = NULL,
  interactive = base::interactive(), images = TRUE)
}
\arguments{
\item{appDir}{Directory of the Shiny application that was tested.}

\item{testnames}{A character vector of names of tests to compare. If NULL,
compare all test results for which there are differences.}

\item{interactive}{If TRUE, use the interactive diff viewer, which runs in a
Shiny app. If FALSE, print a textual diff, generated by
\code{\link{textTestDiff}}.}

\item{images}{Compare screenshot images (only used when \code{interactive} is
FALSE).}
}
\value{
A character vector the same length as \code{testnames}, with
  \code{"accept"} or \code{"reject"} for each test.
}
\description{
View differences in test results
}
\seealso{
\code{\link{textTestDiff}} to get a text diff as a string.
}
