% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_epa.R
\name{k.epa}
\alias{k.epa}
\title{Rescaled Epanechnikov kernel}
\usage{
k.epa(g, s)
}
\arguments{
\item{g}{A numeric value or vector which contains the bandwidth(s).}

\item{s}{A numeric value or vector with the values of the variable in which the kernel will be evaluated.}
}
\value{
Rescaled Epanechnikov kernel for the given value \code{s} and bandwidth \code{g}.
}
\description{
This function computes the rescaled Epanechnikov kernel for a given value \code{s} and bandwidth \code{g}:
\deqn{K\left(\frac{s}{g}\right) = \frac{3}{4g} \left( 1 - \left(\frac{s}{g}\right)^2 \right) I\left(\left|\frac{s}{g}\right| \leq 1\right),}
where \eqn{I} is the indicator function (it takes the value 1 if the condition is true and 0 otherwise).
}
\examples{
k.epa(g=5,s=2)
k.epa(g=5,s=c(2,1.5))
k.epa(g=c(5,6),s=c(2,1.5))
}
