% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cd_sm_uncured.R
\name{kNN.Mahalanobis}
\alias{kNN.Mahalanobis}
\title{K Nearest Neighbors with Mahalanobis Distance}
\usage{
kNN.Mahalanobis(x, time, k)
}
\arguments{
\item{x}{A numeric vector of length \eqn{n} giving the covariate values.}

\item{time}{A numeric vector giving the observed times.}

\item{k}{The number of nearest neighbors to search.}
}
\value{
A matrix with \eqn{n} rows and \code{k} columns. Each row represents
each pair \eqn{(X_i, T_i)}. The values in each row give the index of the
\code{k} nearest neighbors considering Mahalanobis distance.
}
\description{
This function computes the \code{k} nearest neighbors for a given set of data points,
where each observation is a pair of the form \eqn{(X, T)}, with \eqn{X} representing a covariate and \eqn{T} the observed time.
The distance between each pair of points is computed using the Mahalanobis distance:
\deqn{ d_M((X_i, T_i), (X_j, T_j)) = \sqrt{ \left( \begin{pmatrix} X_i \\ T_i \end{pmatrix} - \begin{pmatrix} X_j \\ T_j \end{pmatrix} \right)^t \Sigma^{-1} \left( \begin{pmatrix} X_i \\ T_i \end{pmatrix} - \begin{pmatrix} X_j \\ T_j \end{pmatrix} \right) }, }
where \eqn{\Sigma} is the variance-covariance matrix of the joint distribution of \eqn{(X, T)}.
}
\examples{
# Some artificial data
set.seed(123)
n <- 50
x <- runif(n, -2, 2) # Covariate values
y <- rweibull(n, shape = 0.5 * (x + 4)) # True lifetimes
c <- rexp(n) # Censoring values
p <- exp(2*x)/(1 + exp(2*x)) # Probability of being susceptible
u <- runif(n)
t  <- ifelse(u < p, pmin(y, c), c) # Observed times
d  <- ifelse(u < p, ifelse(y < c, 1, 0), 0) # Uncensoring indicator
kNN.Mahalanobis(x=x, time=t, k=5)
}
\references{
Mahalanobis, P. C. (1936). On the generalised distance in statistics. Proceedings of the National Institute of Sciences of India, 2, 49-55.
}
