% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_series.R
\name{draw_sig_corrplot}
\alias{draw_sig_corrplot}
\title{Plot correlation between signature activities}
\usage{
draw_sig_corrplot(mat_list, order = "original", type = "lower",
  sig.level = 0.05, ...)
}
\arguments{
\item{mat_list}{a \code{list} contain correlation and p value matrix etc., obtain
it from \link{sig_get_correlation} function.}

\item{order}{Character, the ordering method of the correlation matrix.
\itemize{
  \item{\code{"original"} for original order (default).}
  \item{\code{"AOE"} for the angular order of the eigenvectors.}
  \item{\code{"FPC"} for the first principal component order.}
  \item{\code{"hclust"} for the hierarchical clustering order.}
  \item{\code{"alphabet"} for alphabetical order.}
}

See function \code{\link{corrMatOrder}} for details.}

\item{type}{Character, \code{"full"} (default), \code{"upper"} or
\code{"lower"}, display full matrix, lower triangular or upper triangular
matrix.}

\item{sig.level}{Significant level,  if the p-value in \code{p-mat} is bigger
than \code{sig.level}, then the corresponding correlation coefficient is
regarded as insignificant. If \code{insig} is \code{"label_sig"}, this may
be an increasing vector of significance levels, in which case \code{pch}
will be used once for the highest p-value interval and multiple times
(e.g. "*", "**", "***") for each lower p-value interval.}

\item{...}{other arguments pass to \code{\link[corrplot:corrplot]{corrplot::corrplot()}} function.}
}
\description{
Plot correlation between signature activities
}
\examples{
\donttest{
# Load copy number signature
load(system.file("extdata", "toy_copynumber_signature.RData",
  package = "sigminer", mustWork = TRUE
))
sig_activity <- sig_get_activity(res$nmfObj)
sig_cor <- sig_get_correlation(sig_activity)
draw_sig_corrplot(sig_cor)
}
}
\seealso{
Other signature plot: \code{\link{draw_sig_activity}},
  \code{\link{draw_sig_profile}},
  \code{\link{draw_subtypes_comparison}}
}
\author{
Shixiang Wang
}
\concept{signature plot}
