% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigprofiler.R
\name{sigprofiler}
\alias{sigprofiler}
\alias{sigprofiler_extract}
\alias{sigprofiler_import}
\title{Extract Signatures with SigProfiler}
\usage{
sigprofiler_extract(
  nmf_matrix,
  output,
  range = 2:5,
  nrun = 10L,
  refit = FALSE,
  refit_plot = FALSE,
  is_exome = FALSE,
  init_method = c("nndsvd_min", "random", "alexandrov-lab-custom", "nndsvd", "nndsvda",
    "nndsvdar"),
  cores = -1L,
  genome_build = c("hg19", "hg38", "mm10", "mm9"),
  use_conda = FALSE,
  py_path = NULL,
  sigprofiler_version = "1.1.3"
)

sigprofiler_import(
  output,
  order_by_expo = FALSE,
  type = c("suggest", "refit", "all")
)
}
\arguments{
\item{nmf_matrix}{a \code{matrix} used for NMF decomposition with rows indicate samples and columns indicate components.}

\item{output}{output directory.}

\item{range}{signature number range, i.e. \code{2:5}.}

\item{nrun}{the number of iteration to be performed to extract each signature number.}

\item{refit}{if \code{TRUE}, then refit the denovo signatures with nnls. Same
meaning as \code{optimize} option in \link{sig_extract} or \link{sig_auto_extract}.}

\item{refit_plot}{if \code{TRUE}, SigProfiler will make
denovo to COSMIC sigantures decompostion plots. However, this may fail due
to some matrix cannot be identified by SigProfiler plot program.}

\item{is_exome}{if \code{TRUE}, the exomes will be extracted.}

\item{init_method}{the initialization algorithm for W and H matrix of NMF.
Options are 'random', 'nndsvd', 'nndsvda', 'nndsvdar', 'alexandrov-lab-custom'
and 'nndsvd_min'.}

\item{cores}{number of cores used for computation.}

\item{genome_build}{I think this option is useless when input is \code{matrix}, keep it
in case it is useful.}

\item{use_conda}{if \code{TRUE}, create an independent conda environment to run SigProfiler.}

\item{py_path}{path to Python executable file, e.g. '/Users/wsx/anaconda3/bin/python'.}

\item{sigprofiler_version}{version of \code{SigProfilerExtractor}. If this
package is not installed, the specified package will be installed.
If this package is installed, this option is useless.}

\item{order_by_expo}{if \code{TRUE}, order the import signatures by their exposures, e.g. the signature
contributed the most exposure in all samples will be named as \code{Sig1}.}

\item{type}{one of 'suggest' (for suggested solution), 'refit' (for refit solution) or 'all' (for all solutions).}
}
\value{
For \code{sigprofiler_extract()}, returns nothing. See \code{output} directory.

For \code{sigprofiler_import()}, a \code{list} containing \code{Signature} object.
}
\description{
This function provides an interface to software SigProfiler.
More please see \url{https://github.com/AlexandrovLab/SigProfilerExtractor}.
Typically, a reference genome is not required because the input is a matrix (my understanding).
}
\examples{
if (FALSE) {
  load(system.file("extdata", "toy_copynumber_tally_W.RData",
    package = "sigminer", mustWork = TRUE
  ))

  reticulate::conda_list()

  sigprofiler_extract(cn_tally_W$nmf_matrix, "~/test/test_sigminer",
    use_conda = TRUE
  )

  sigprofiler_extract(cn_tally_W$nmf_matrix, "~/test/test_sigminer",
    use_conda = FALSE, py_path = "/Users/wsx/anaconda3/bin/python"
  )
}
}
