% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmpiricalFns.R
\name{permutationScoreModel}
\alias{permutationScoreModel}
\title{Empirical permuation test of significance of scoreFn(modelValues,yValues) >= scoreFn(modelValues,perm(yValues)).}
\usage{
permutationScoreModel(modelValues, yValues, scoreFn, ...,
  returnScores = FALSE, nRep = 100, parallelCluster = NULL)
}
\arguments{
\item{modelValues}{numeric array of predictions.}

\item{yValues}{numeric/logical array of outcomes, depedendent, or truth values}

\item{scoreFn}{function with signature scoreFn(modelValues,yValues) returning scalar numeric score.}

\item{...}{not used, forces later arguments to be bound by name}

\item{returnScores}{logical if TRUE return detailed permutedScores}

\item{nRep}{integer number of repititions to perform}

\item{parallelCluster}{optional snow-style parallel cluster.}
}
\value{
summaries
}
\description{
Treat permutaiton re-samples as similar to bootstrap replications.
}
\examples{

set.seed(25325)
y <- 1:5
m <- c(1,1,2,2,2)
cor.test(m,y,alternative='greater')
f <- function(modelValues,yValues) cor(modelValues,yValues)
permutationScoreModel(m,y,f)

}
