% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_path.R
\name{sc_path}
\alias{sc_path}
\alias{sc_path.list}
\alias{sc_path.default}
\alias{sc_path.PATH}
\alias{sc_path.PATH0}
\alias{sc_path.ARC}
\alias{sc_path.SC}
\alias{sc_path.SC0}
\alias{sc_path.matrix}
\alias{sc_path.sf}
\alias{sc_path.sfc}
\alias{sc_path.MULTIPOLYGON}
\alias{sc_path.POLYGON}
\alias{sc_path.LINESTRING}
\alias{sc_path.MULTILINESTRING}
\alias{sc_path.POINT}
\alias{sc_path.MULTIPOINT}
\alias{sc_path.GEOMETRYCOLLECTION}
\alias{sc_path.Spatial}
\title{Path decomposition}
\usage{
sc_path(x, ...)

\method{sc_path}{list}(x, ids = NULL, ...)

\method{sc_path}{default}(x, ...)

\method{sc_path}{PATH}(x, ...)

\method{sc_path}{PATH0}(x, ...)

\method{sc_path}{ARC}(x, ...)

\method{sc_path}{SC}(x, ...)

\method{sc_path}{SC0}(x, ...)

\method{sc_path}{matrix}(x, ...)

\method{sc_path}{sf}(x, ids = NULL, ...)

\method{sc_path}{sfc}(x, ids = NULL, ...)

\method{sc_path}{MULTIPOLYGON}(x, ...)

\method{sc_path}{POLYGON}(x, ...)

\method{sc_path}{LINESTRING}(x, ...)

\method{sc_path}{MULTILINESTRING}(x, ...)

\method{sc_path}{POINT}(x, ...)

\method{sc_path}{MULTIPOINT}(x, ...)

\method{sc_path}{GEOMETRYCOLLECTION}(x, ...)

\method{sc_path}{Spatial}(x, ids = NULL, ...)
}
\arguments{
\item{x}{input object}

\item{...}{arguments passed to methods}

\item{ids}{object id, one for each object in the \code{sfc}}
}
\value{
data frame of path identity and properties
}
\description{
Start in the middle, and build the 'path-link-vertex' table.

Paths.
}
\details{
Paths have properties of their type, their number of vertices, their geometric
dimension and which object they occur in.
}
\examples{
sc_path(minimal_mesh)
sc_path(PATH(minimal_mesh))
sc_path(sfzoo$multipolygon)
sc_path(sfzoo$polygon)
sc_path(sfzoo$linestring)
sc_path(sfzoo$multilinestring)
sc_path(sfzoo$point)
sc_path(sfzoo$multipoint)
sc_path(sfzoo$multipoint)
}
\seealso{
\code{sc_coord} for the coordinates part of the model, \code{sc_object} for
the features, and \code{PATH} for the full model.
}
