% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{retrieveGenotypes}
\alias{retrieveGenotypes}
\title{Retrieve a matrix of simulated genotypes for a specific set of individual IDs}
\usage{
retrieveGenotypes(ids)
}
\arguments{
\item{ids}{Vector of ids of individuals to retrieve.}
}
\description{
Retrieve a matrix of simulated genotypes for a specific set of individual IDs
}
\examples{

library("sim1000G")

examples_dir = system.file("examples", package = "sim1000G")
vcf_file = file.path(examples_dir, "region.vcf.gz")
vcf = readVCF( vcf_file, maxNumberOfVariants = 100 ,
               min_maf = 0.12 ,max_maf = NA)

# For realistic data use the function downloadGeneticMap
generateUniformGeneticMap()

startSimulation(vcf, totalNumberOfIndividuals = 200)

ped1 = newNuclearFamily(1)

retrieveGenotypes(ped1$gtindex)

}
