% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/simulation.r
\name{doLTCF}
\alias{doLTCF}
\title{Last Timepoint Carried Forward (LTCF)}
\usage{
doLTCF(data, outcome)
}
\arguments{
\item{data}{Simulated \code{data.frame} in wide format}

\item{outcome}{Character string specifying the outcome node that is the indicator of the end of follow-up (observations with value of the outcome variable being 1 indicate that the end of follow-up has been reached). The outcome variable must be a binary node that was declared with \code{EFU=TRUE}.}
}
\value{
Modified simulated \code{data.frame}, forward imputed all variables after outcome switched to 1.
}
\description{
Carry forward (forward impute) all missing variable values for simulated observations that have reached the end of their follow-up, as defined by the node of type (EOF=TRUE).
}

