% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_glm_func.r
\name{sim_glm_nested}
\alias{sim_glm_nested}
\title{Simulate two level logistic regression model}
\usage{
sim_glm_nested(
  fixed,
  random,
  fixed_param,
  random_param = list(),
  cov_param,
  n,
  p,
  data_str,
  cor_vars = NULL,
  fact_vars = list(NULL),
  unbal = FALSE,
  unbal_design = NULL,
  contrasts = NULL,
  outcome_type,
  cross_class_params = NULL,
  knot_args = list(NULL),
  ...
)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation.
To suppress intercept add -1 to formula.}

\item{random}{One sided formula for random effects in the simulation. 
Must be a subset of fixed.}

\item{fixed_param}{Fixed effect parameter values (i.e. beta weights). 
Must be same length as fixed.}

\item{random_param}{A list of named elements that must contain: 
\itemize{
   \item  random_var = variance of random parameters,
   \item  rand_gen = Name of simulation function for random effects.
}
       Optional elements are:
\itemize{
   \item ther: Theorectial mean and variance from rand_gen,
   \item ther_sim: Simulate mean/variance for standardization purposes,
   \item cor_vars: Correlation between random effects,
   \item ...: Additional parameters needed for rand_gen function.
 }}

\item{cov_param}{List of arguments to pass to the continuous generating 
function, must be the same order as the variables specified in fixed. 
This list does not include intercept, time, factors, or 
interactions. Required arguments include:
\itemize{
  \item dist_fun: This is a quoted R distribution function.
  \item var_type: This is the level of variable to generate. Must be 
    'level1' or 'level2'.
    Must be same order as fixed formula above.
}
Optional arguments to the distribution functions are in a nested list,
 see the examples or vignettes for example code.}

\item{n}{Cluster sample size.}

\item{p}{Within cluster sample size.}

\item{data_str}{Type of data. Must be "cross", "long", or "single".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels = Number of levels for ordinal or factor variables.
     \item var_type = Must be 'level1' or 'level2'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{unbal}{A vector of sample sizes for the number of observations for 
each level 2 cluster. Must have same length as level two sample size n. 
Alternative specification can be TRUE, which uses additional argument, 
unbal_design.}

\item{unbal_design}{When unbal = TRUE, this specifies the design for unbalanced
simulation in one of two ways. It can represent the minimum and maximum 
sample size within a cluster via a named list. This will be drawn from a 
random uniform distribution with min and max specified. 
Secondly, the sample sizes within each cluster can be specified. 
This takes the form of a vector that must have the same length 
as the level two sample size.}

\item{contrasts}{An optional list that specifies the contrasts to be used 
for factor variables (i.e. those variables with .f or .c). 
See \code{\link{contrasts}} for more detail.}

\item{outcome_type}{A vector specifying the type of outcome, must be either
logistic or poisson. Logitstic outcome will be 0/1 and poisson outcome will
be counts.}

\item{cross_class_params}{A list of named parameters when cross classified 
data structures are desired. Must include the following arguments:
 \itemize{
  \item num_ids: The number of cross classified clusters. These are in 
       addition to the typical cluster ids
  \item random_param: This argument is a list of arguments passed to 
     \code{\link{sim_rand_eff}}. These must include:
    \itemize{
     \item random_var: The variance of the cross classified random effect
     \item rand_gen: The random generating function used to generate the 
        cross classified random effect.
    }
    Optional elements are:
  \itemize{
      \item ther: Theorectial mean and variance from rand_gen,
      \item ther_sim: Simulate mean/variance for standardization purposes,
      \item cor_vars: Correlation between random effects,
      \item ...: Additional parameters needed for rand_gen function.
  } 
 }}

\item{knot_args}{A nested list of named knot arguments. See \code{\link{sim_knot}} 
for more details. Arguments must include:
  \itemize{
    \item var
    \item knot_locations
  }}

\item{...}{Not currently used.}
}
\description{
Takes simulation parameters as inputs and returns simulated data.
}
\details{
Simulates data for the nested logistic regression models.  Returns a 
data frame with ID variables, fixed effects, random effects, and many
other variables to help when running simulation studies.
}
\examples{
# Longitudinal linear mixed model example
fixed <- ~1 + time + diff + act + time:act
random <- ~1 + time + diff
fixed_param <- c(0.1, -0.2, 0.15, 0.5, -0.02)
random_param <- list(random_var = c(7, 4, 2), rand_gen = 'rnorm')
cov_param <- list(dist_fun = c('rnorm', 'rnorm'),
   var_type = c("level1", "level2"),
   opts = list(list(mean = 0, sd = 1.5),
   list(mean = 0, sd = 4)))
n <- 150
p <- 30
data_str <- "long"
temp_long <- sim_glm(fixed, random, random3 = NULL, fixed_param, 
random_param, random_param3 = NULL,
 cov_param, k = NULL, n, p, data_str = data_str, outcome_type = 'logistic')
}
