% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_rejection.R
\name{calc_rejection}
\alias{calc_rejection}
\title{Calculate rejection rate and MCSE}
\usage{
calc_rejection(data, p_values, alpha = 0.05, format = "wide")
}
\arguments{
\item{data}{data frame or tibble containing the simulation results.}

\item{p_values}{Vector or name of column from \code{data} containing
p-values.}

\item{alpha}{Scalar or vector indicating the nominal alpha level(s). Default
value is set to the conventional .05.}

\item{format}{Option \code{"wide"} (the default) will produce a tibble with
one row, with separate variables for each specified \code{alpha}. Option
\code{"long"} will produce a tibble with one row per specified
\code{alpha}.}
}
\value{
A tibble containing the number of simulation iterations, performance
  criteria estimate and the associated MCSE.
}
\description{
Calculates rejection rate. The function also calculates the
  associated Monte Carlo standard error.
}
\examples{
calc_rejection(data = t_res, p_values = p_val)


}
