% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmer-methods.R
\name{simmer}
\alias{simmer}
\title{Create a Simulator}
\usage{
simmer(name = "anonymous", verbose = FALSE, mon = monitor_mem(),
  log_level = 0)
}
\arguments{
\item{name}{the name of the simulator.}

\item{verbose}{enable showing activity information.}

\item{mon}{monitor (in memory by default); see \code{\link{monitor}} for
other options.}

\item{log_level}{debugging level (see \code{\link{log_}}).}
}
\value{
Returns a simulation environment.
}
\description{
This method initialises a simulation environment.
}
\examples{
## a simple trajectory that prints a message
t0 <- trajectory("my trajectory") \%>\%
  log_("arrival generated")

## create an empty simulation environment
env <- simmer("SuperDuperSim")
env

## add a generator and attach it to the trajectory above
env \%>\% add_generator("dummy", t0, function() 1)

## run for some time
env \%>\% run(until=4.5)
env \%>\% now()           # current simulation time
env \%>\% peek()          # time for the next event
env \%>\% stepn()         # execute next event

}
\seealso{
Available methods by category:
\itemize{

\item Simulation control: \code{\link{stepn}}, \code{\link{run}},
\code{\link{now}}, \code{\link{peek}}, \code{\link{reset}}

\item Resources: \code{\link{add_resource}}, \code{\link{get_resources}},
\code{\link{get_capacity}}, \code{\link{get_queue_size}},
\code{\link{get_server_count}}, \code{\link{get_queue_count}},
\code{\link{get_capacity_selected}}, \code{\link{get_queue_size_selected}},
\code{\link{get_server_count_selected}}, \code{\link{get_queue_count_selected}},
\code{\link{get_selected}}

\item Sources: \code{\link{add_generator}}, \code{\link{add_dataframe}},
\code{\link{get_sources}}, \code{\link{get_n_generated}},
\code{\link{get_trajectory}}

\item Globals: \code{\link{add_global}}, \code{\link{get_global}}.

\item Data retrieval: \code{\link{get_mon_arrivals}},
\code{\link{get_mon_attributes}}, \code{\link{get_mon_resources}}

}
}
