% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{UCI.ISOLET.ABC}
\alias{UCI.ISOLET.ABC}
\title{ISOLET Data Set (ABC)}
\format{A data frame with 900 rows and 618 variables}
\source{
Dataset downloaded from the UCI Machine Learning Repository.
\url{http://archive.ics.uci.edu/ml/datasets/ISOLET}

Creators:

Ron Cole and Mark Fanty
Department of Computer Science and Engineering,
Oregon Graduate Institute, Beaverton, OR 97006.
cole 'at' cse.ogi.edu, fanty 'at' cse.ogi.edu

Donor:

Tom Dietterich
Department of Computer Science
Oregon State University, Corvallis, OR 97331
tgd 'at' cs.orst.edu
}
\usage{
data(UCI.ISOLET.ABC)
}
\description{
This data set was generated as follows. 150 subjects spoke the name of each letter of the alphabet twice.
Hence, we have 52 training examples from each speaker.
}
\details{
To reduce package size, only the 3 first letters are included here. The full dataset can be obtained
from \url{http://archive.ics.uci.edu/ml/datasets/ISOLET}.

The features are described in the paper by Cole and Fanty cited below.
The features include spectral coefficients; contour features, sonorant features, pre-sonorant features,
and post-sonorant features. Exact order of appearance of the features is not known.
}
\examples{
# NB: 50 iterations isn't enough in this case,
# it was chosen so that the example runs fast enough on CRAN check farm
data(UCI.ISOLET.ABC);
X=as.matrix(sN.normalizeDF(as.data.frame(UCI.ISOLET.ABC[,1:617])));
y=as.matrix(UCI.ISOLET.ABC[,618]-1);
myMLP=sN.MLPtrain(X=X,y=y,hidden_layer_size=20,it=50,lambda=0.5,alpha=0.5);
myPrediction=sN.MLPpredict(nnModel=myMLP,X=X,raw=FALSE);
table(y,myPrediction);
}
\references{
Fanty, M., Cole, R. (1991). Spoken letter recognition. In Lippman, R. P., Moody, J.,
and Touretzky, D. S. (Eds). Advances in Neural Information Processing Systems 3. San Mateo, CA: Morgan Kaufmann.
[\url{http://rexa.info/paper/bee6de062d0d168c5c5b5290b11cd6b12ca8472e}]
}
\keyword{datasets}

