% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_hbar.R
\name{gg_hbar_col}
\alias{gg_hbar_col}
\title{Horizontal bar ggplot that is coloured.}
\usage{
gg_hbar_col(data, x_var, y_var, col_var, text_var = NULL,
  position = NULL, pal = NULL, pal_na = "#7F7F7F", pal_rev = FALSE,
  width = NULL, alpha = 1, size_line = 0.5, title = NULL,
  title_wrap = 75, subtitle = NULL, subtitle_wrap = 75,
  x_balance = FALSE, x_expand = NULL, x_gridlines_minor = FALSE,
  x_labels = scales::comma, x_na = TRUE, x_pretty_n = 5,
  x_title = NULL, x_title_wrap = 50, x_trans = "identity",
  x_zero = TRUE, x_zero_line = NULL, y_balance = FALSE,
  y_expand = NULL, y_labels = NULL, y_na = TRUE, y_pretty_n = 6,
  y_reorder = FALSE, y_rev = FALSE, y_title = NULL,
  y_title_wrap = 50, y_zero = FALSE, y_zero_line = NULL,
  col_cuts = NULL, col_labels = NULL, col_method = NULL,
  col_na = TRUE, col_pretty_n = 5, col_rev = FALSE,
  col_right_closed = TRUE, col_title = NULL, col_title_wrap = 25,
  caption = NULL, caption_wrap = 75, font_family = "",
  font_size_title = NULL, font_size_body = NULL, mobile = FALSE)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x scale. Required input.}

\item{y_var}{Unquoted variable to be on the y scale (i.e. character, factor, logical, numeric, date or datetime). If numeric, date or datetime, variable values are bins that are mutually exclusive and equidistant. Required input.}

\item{col_var}{Unquoted categorical or numeric variable to colour the bars. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{position}{Whether bars are positioned by "dodge" or "stack". Defaults to "dodge".}

\item{pal}{Character vector of hex codes.}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{width}{Width of bars. Defaults to 0.75.}

\item{alpha}{The alpha of the fill. Defaults to 1.}

\item{size_line}{The size of the outlines of bars.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 60.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 60.}

\item{x_balance}{For a numeric x variable, add balance to the x scale so that zero is in the centre of the x scale.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_gridlines_minor}{TRUE or FALSE of whether to add minor gridlines to the x scale. Defaults to FALSE.}

\item{x_labels}{A function or named vector to modify x scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_na}{TRUE or FALSE of whether to include x_var NA values. Defaults to TRUE.}

\item{x_pretty_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 3.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_trans}{For a numeric x variable, a string specifying a transformation for the x scale, such as "log10" or "sqrt". Defaults to "identity".}

\item{x_zero}{For a numeric x variable, TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to TRUE.}

\item{x_zero_line}{For a numeric x variable, TRUE or FALSE whether to add a zero reference line to the x scale. Defaults to TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_balance}{For a numeric y variable, add balance to the y scale so that zero is in the centre. Defaults to FALSE.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_na}{TRUE or FALSE of whether to include y_var NA values. Defaults to TRUE.}

\item{y_pretty_n}{For a numeric or date y variable, the desired number of intervals on the y scale, as calculated by the pretty algorithm. Defaults to 4.}

\item{y_reorder}{For a categorical y variable, TRUE or FALSE of whether the y variable variable is to be reordered by the y variable. Defaults to FALSE.}

\item{y_rev}{For a categorical variable, TRUE or FALSE of whether the y variable variable is reversed. Defaults to FALSE.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{y_zero}{For a numeric y variable, TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to FALSE.}

\item{y_zero_line}{For a numeric y variable, TRUE or FALSE of whether to add a zero reference line to the y scale. Defaults to TRUE if there are positive and negative values in y_var. Otherwise defaults to FALSE.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_labels}{A function or named vector to modify colour scale labels. Defaults to stringr::str_to_sentence for categorical colour variables and scales::comma for numeric colour variables. Use ggplot2::waiver() to keep colour labels untransformed.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." If numeric, defaults to "bin".}

\item{col_na}{TRUE or FALSE of whether to include col_var NA values. Defaults to TRUE.}

\item{col_pretty_n}{For a numeric colour variable of "bin" col_method, the desired number of intervals on the colour scale, as calculated by the pretty algorithm. Defaults to 5.}

\item{col_rev}{TRUE or FALSE of whether the colour scale is reversed. Defaults to FALSE. Defaults to FALSE.}

\item{col_right_closed}{For a numeric colour variable, TRUE or FALSE of whether bins or quantiles are to be cut right-closed. Defaults to TRUE.}

\item{col_title}{Colour title string for the legend. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where mobile equals TRUE.}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 75.}

\item{font_family}{Font family to use. Defaults to "".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within a shiny app with the mobileDetect function, then use mobile = input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Horizontal bar ggplot that is coloured, but not facetted.
}
\examples{
library(dplyr)
library(simplevis)
library(palmerpenguins)

plot_data <- penguins \%>\% 
  group_by(species, sex) \%>\% 
  summarise(body_mass_g = mean(body_mass_g, na.rm = TRUE))  

gg_hbar_col(plot_data, 
            x_var = body_mass_g, 
            y_var = species, 
            col_var = sex)

gg_hbar_col(plot_data, 
            x_var = body_mass_g, 
            y_var = species, 
            col_var = sex, 
            position = "stack")
            
}
