% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_labels.R
\name{interval_labels}
\alias{interval_labels}
\title{Convert numeric or interval cuts to simple and pretty labels.}
\usage{
interval_labels(cuts, digits = NULL, left_closed = TRUE)
}
\arguments{
\item{cuts}{A vector or numeric or character interval cuts.}

\item{left_closed}{If cuts are numeric, TRUE or FALSE of whether intervals are to be left-closed. Defaults to TRUE.}

\item{format}{A function to apply to the numeric values, e.g. scales::label_comma().}
}
\value{
A vector of character labels.
}
\description{
Convert numeric or interval cuts to simple and pretty labels.
}
\examples{
simplevis:::interval_labels(c(0, 0.1, 3, 4.1, 7, 100, Inf))

simplevis:::interval_labels(c("(0, 10]", "(10, 50]", "(50, 100]"))

simplevis:::interval_labels(c("[0, 10)", "[10, 50)", "[50, 100)"))

}
\keyword{internal}
