% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_fits.R
\name{apply_fits}
\alias{apply_fits}
\title{Run a given function or formula expression on a
simpr_mod object and tidy the output.}
\usage{
apply_fits(obj, .f, ..., .progress = FALSE, .options = furrr_options())
}
\arguments{
\item{obj}{a \code{simpr_tibble} with
repetition number, metaparameters, simulated
data, and fitted models, from
\code{\link[=fit.simpr_tibble]{fit}}}

\item{.f}{A function or \code{purrr}-style
lambda function (see
\code{\link[purrr]{as_mapper}}) used for
computing on the fit object}

\item{\dots}{Additional arguments to \code{.f}.}

\item{.progress}{A logical, for whether or not
to print a progress bar for multiprocess,
multisession, and multicore plans .}

\item{.options}{The \code{future} specific
options to use with the workers when using
futures. This must be the result from a call
to
\code{\link[furrr:furrr_options]{furrr_options()}}.}
}
\value{
A \code{tibble} with columns \code{.sim_id},
  \code{rep}, \code{Source} (which contains the name of the
  fit column), any metaparameters from
  \code{\link{define}}, and additional columns
  containing the results of \code{.f} applied to each fit
  object.
}
\description{
This function applies a given function to all
fit objects and returns the result in a tidy
tibble.  Any function or \code{purrr}-style
lambda function can be used.
}
\examples{
set.seed(100)
logit_fit = specify(a = ~ sample(0:1, size = n, replace = TRUE),
        b = ~ a + rlnorm(n)) \%>\%
  define(n = c(40, 50)) \%>\%
  generate(1) \%>\%
  fit(logit = ~ glm(a ~ b, family = "binomial"))

logit_fit \%>\%
  apply_fits(broom::augment)

## Arguments to the function can be passed in ...
logit_fit \%>\%
  apply_fits(broom::augment, se_fit = TRUE)

## Equivalent to tidy_fits()
logit_fit \%>\%
  apply_fits(broom::tidy)

## Using a purrr-style lambda function
logit_fit \%>\%
  apply_fits(~ summary(.)$cov.scaled)

}
\seealso{
\code{\link{tidy_fits}},
  \code{\link{glance_fits}}
}
