% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCorData.R
\name{genCorData}
\alias{genCorData}
\title{Create correlated data}
\usage{
genCorData(n, mu, sigma, corMatrix = NULL, rho, corstr = "ind",
  cnames = NULL, idname = "id")
}
\arguments{
\item{n}{Number of observations}

\item{mu}{A vector of means. The length of mu must be nvars.}

\item{sigma}{Standard deviation of variables. If standard deviation differs for
each variable, enter as a vector with the same length as the mean vector mu. If
the standard deviation is constant across variables, as single value can be entered.}

\item{corMatrix}{Correlation matrix can be entered directly. It must be symmetrical and
positive semi-definite. It is not a required field; if a matrix is not provided, then a
structure and correlation coefficient rho must be specified.}

\item{rho}{Correlation coefficient, -1 <= rho <= 1. Use if corMatrix is not provided.}

\item{corstr}{Correlation structure of the variance-covariance matrix
defined by sigma and rho. Options include "ind" for an independence
structure, "cs" for a compound symmetry structure, and "ar1" for an
autoregressive structure.}

\item{cnames}{Explicit column names. A single string with names separated
by commas. If no string is provided, the default names will be V#, where #
represents the column.}

\item{idname}{The name of the index id name. Defaults to "id."}
}
\value{
A data.table with n rows and the k + 1 columns, where k is the number of
means in the vector mu.
}
\description{
Create correlated data
}

