% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deficit_power.R
\name{TD_power}
\alias{TD_power}
\title{Power calculator for TD}
\usage{
TD_power(
  case,
  mean = 0,
  sd = 1,
  sample_size = NULL,
  power = NULL,
  alternative = c("less", "greater", "two.sided"),
  alpha = 0.05,
  spec = 0.005
)
}
\arguments{
\item{case}{A single value from the expected case observation.}

\item{mean}{The expected mean of the control sample.}

\item{sd}{The expected standard deviation of the control sample.}

\item{sample_size}{The size of the control sample, vary this parameter to see
how the sample size affects power. One of sample size or power must be
specified, not both.}

\item{power}{A single value between 0 and 1 specifying desired power for
calculating necessary sample size. One of sample size or power must be
specified, not both.}

\item{alternative}{The alternative hypothesis. A string of either "less" (default),
"greater" or "two.sided".}

\item{alpha}{The specified Type I error rate. This can also be varied, with
effects on power.}

\item{spec}{A single value between 0 and 1. If desired power is given as
input the function will utilise a search algorithm to find the sample size
needed to reach the desired power. However, if the power specified is
greater than what is actually possible to achieve the algorithm could
search forever. Hence, when power does not increase substantially for
any additional participant in the sample, the algorithm stops.
By default the algorithm stops when power does not increase more
than 0.5\% for any added participant, but by varying \code{spec},
this specificity can be changed.}
}
\value{
Either a single value of the exact power, if sample size is given. Or
  a dataframe consisting of both the sample size and the exact power such
  size would yield.
}
\description{
Calculates exact power given sample size or sample size given power, using
analytical methods for the frequentist test of deficit for a specified case
score and mean and standard deviation for the control sample. The mean and
standard deviation defaults to 0 and 1, so if no other values are given the
case score is interpreted as deviation from the mean in standard deviations.
}
\examples{
TD_power(case = -2, mean = 0, sd = 1, sample_size = 20)
TD_power(case = -2, mean = 0, sd = 1, power = 0.8)
}
