% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirus.R
\name{sirus.print}
\alias{sirus.print}
\title{Print SIRUS}
\usage{
sirus.print(sirus.m)
}
\arguments{
\item{sirus.m}{A SIRUS model generated by sirus.fit.}
}
\value{
Formatted list of rules.
}
\description{
Print the list of rules output by SIRUS.
}
\examples{
## load sirus
require(sirus)

## prepare data
data <- iris
y <- rep(0, nrow(data))
y[data$Species == 'setosa'] = 1
data$Species <- NULL

## fit sirus
sirus.m <- sirus.fit(data, y)

## print sirus model
sirus.print(sirus.m)

}
