% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_torch_temporal_attention_encoder.R
\name{.torch_scaled_dot_product_attention}
\alias{.torch_scaled_dot_product_attention}
\title{Torch module for calculating attention from query, keys and values}
\usage{
.torch_scaled_dot_product_attention(temperature, attn_dropout = 0.1)
}
\arguments{
\item{temperature}{Weight score of the attention module.}

\item{attn_dropout}{Dropout rate to be applied to the attention
module.}

\item{query}{Query tensor.}

\item{keys}{Tensor with keys.}

\item{values}{Tensor with values.}
}
\value{
A list with the .
}
\description{
Defines a torch module for temporal attention encoding.

In order to calculate attentions with a query, as I said in the last article,
this function takes the dot product of query with the keys
and gets scores/weights for the values.
Each score/weight the relevance between the query and each key.
And you reweight the values with the scores/weights,
and take the summation of the reweighted values.

This implementation is based on the code made available by Vivien Garnot
https://github.com/VSainteuf/lightweight-temporal-attention-pytorch
}
\references{
Vivien Sainte Fare Garnot and Loic Landrieu,
"Lightweight Temporal Self-Attention for Classifying Satellite Image
Time Series", https://arxiv.org/abs/2007.00586
}
\author{
Charlotte Pelletier, \email{charlotte.pelletier@univ-ubs.fr}

Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Souza, \email{lipecaso@gmail.com}
}
\keyword{internal}
