% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.som_map}
\alias{plot.som_map}
\title{Plot a SOM map}
\usage{
\method{plot}{som_map}(x, y, ..., type = "codes", band = 1)
}
\arguments{
\item{x}{Object of class "som_map".}

\item{y}{Ignored.}

\item{...}{Further specifications for \link{plot}.}

\item{type}{Type of plot: "codes" for neuron weight (time series) and
"mapping" for the number of samples allocated in a neuron.}

\item{band}{What band will be plotted.}
}
\value{
Called for side effects.
}
\description{
plots a SOM map generated by "sits_som_map".
The plot function produces different plots based on the input data.
If type is "codes", plots the vector weight for in each neuron.
If type is "mapping", shows where samples are mapped.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # create a SOM map
    som_map <- sits_som_map(samples_modis_ndvi)
    # plot the SOM map
    plot(som_map)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
