% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sjp.aov1}
\alias{sjp.aov1}
\title{Plot One-Way-Anova tables}
\usage{
sjp.aov1(depVar, grpVar, meansums = FALSE, type = "dots",
  hideErrorBars = FALSE, title = NULL, axisLabels.y = NULL,
  reverseOrder = FALSE, stringIntercept = "(Intercept)",
  showAxisLabels.y = TRUE, axisTitle.x = NULL, axisLimits = NULL,
  errorBarColor = NULL, geom.colors = c("#3366a0", "#aa3333"),
  geom.size = 3, breakTitleAt = 50, breakLabelsAt = 25,
  gridBreaksAt = NULL, expand.grid = FALSE, showValueLabels = TRUE,
  labelDigits = 2, showPValueLabels = TRUE, showModelSummary = TRUE,
  printPlot = TRUE)
}
\arguments{
\item{depVar}{The dependent variable. Will be used with following formular:
\code{aov(depVar ~ grpVar)}}

\item{grpVar}{The grouping variable, as unordered factor. Will be used with following formular:
\code{aov(depVar ~ grpVar)}}

\item{meansums}{If \code{TRUE}, the values reported are the true group mean values. If \code{FALSE} (default),
the values are reported in the standard way, i.e. the values indicate the difference of
the group mean in relation to the intercept (reference group).}

\item{type}{Indicates Whether the group means should be plotted as \code{"dots"} (aka forest plots, default)
or as \code{"bars"}.}

\item{hideErrorBars}{If \code{TRUE}, the error bars that indicate the confidence intervals of the group means are not
shown. Only applies if parameter \code{type} is \code{"bars"}. Default value is \code{FALSE}.}

\item{title}{Diagram's title as string.
Example: \code{title=c("my title")}
Use \code{"NULL"} to automatically detect variable names that will be used as title
(see \code{\link{sji.setVariableLabels}}) for details). Use \code{title=""} for a blank title.}

\item{axisLabels.y}{Value labels of the grouping variable \code{grpVar} that are used for labelling the
grouping variable axis. Passed as vector of strings.
Example: \code{axisLabels.y=c("Label1", "Label2", "Label3")}. \cr
Note: If you use the \code{\link{sji.SPSS}} function and the \code{\link{sji.getValueLabels}} function, you receive a
list object with label string. The labels may also be passed as list object. They will be unlisted and
converted to character vector automatically. See examples below. \cr
Note: In case \code{type} is \code{"bars"}, the \code{grpVar} will be plotted along
the x-axis.}

\item{reverseOrder}{If \code{TRUE}, the order of the factor categories (groups) is reversed.
Default is \code{FALSE}.}

\item{stringIntercept}{A string that indicates the reference group (intercept), that is appended to
the value label of the grouping variable. Default is \code{"(Intercept)"}.}

\item{showAxisLabels.y}{Whether y axis text (category value) should be shown (use \code{TRUE})
or not. Default is \code{TRUE}.}

\item{axisTitle.x}{A label for the x axis. Default is \code{NULL}, which means no x-axis title.
Use \code{"auto"} to automatically detect variable names that will be used as title
(see \code{\link{sji.setVariableLabels}}) for details).}

\item{axisLimits}{Defines the range of the axis where the beta coefficients and their confidence intervalls
are drawn. By default, the limits range from the lowest confidence interval to the highest one, so
the diagram has maximum zoom. Use your own values as 2-value-vector, for instance: \code{limits=c(-0.8,0.8)}.}

\item{errorBarColor}{The color of the error bars that indicate the confidence intervalls
of the group means. Default is \code{NULL}, which means that if \code{type} is \code{"dots"},
the \code{pointColor} value will be used as error bar color. In case \code{type} is \code{"bars"},
\code{"black"} will be used as error bar color.}

\item{geom.colors}{The colors of the points resp. bars (depending on \code{type}) that indicate the mean-value.
\code{geom.colors} is a
vector with two values: the first indicating groups with positive means and the second
indicating negative means. Default is \code{c("#3366a0", "#aa6633")}.}

\item{geom.size}{The size of the points resp. bars (depending on \code{type}) that indicate the
mean-value. Default is 3, which is suitable for \code{type="dots"}. Use something like
0.5 is \code{type="bars"}.}

\item{breakTitleAt}{Wordwrap for diagram title. Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the category labels are displayed in
one line and when a line break is inserted}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed. Default is \code{NULL}, so \code{\link{pretty}} gridbeaks will be used.}

\item{expand.grid}{If \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{showValueLabels}{Whether the value labels (mean differences) should be plotted
to each dot or not.}

\item{labelDigits}{The amount of digits for rounding the estimations (see \code{showValueLabels}).
Default is 2, i.e. estimators have 2 digits after decimal point.}

\item{showPValueLabels}{Whether the significance levels of each category/group should be appended
to values or not.}

\item{showModelSummary}{If \code{TRUE} (default), a summary of the anova model with
Sum of Squares between groups (ssb), Sum of Squares within groups (ssw), multiple and adjusted
R-square and F-Test is printed to the lower right corner
of the diagram. Default is \code{TRUE}.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot One-Way-Anova table sum of squares (SS) of each factor level (group)
               against the dependent variable. The SS of the factor variable against the
               dependent variable (variance within and between groups) is printed to
               the model summary.
}
\examples{
data(efc)
# note: "grpVar" does not need to be a factor.
# coercion to factor is done by the function
sjp.aov1(efc$c12hour, efc$e42dep)


data(efc)
efc.val <- sji.getValueLabels(efc)
efc.var <- sji.getVariableLabels(efc)
sjp.aov1(efc$c12hour,
         as.factor(efc$e42dep),
         axisLabels.y = efc.val['e42dep'],
         axisTitle.x = efc.var[['c12hour']])

# -------------------------------------------------
# auto-detection of value labels and variable names
# -------------------------------------------------
efc <- sji.setVariableLabels(efc, efc.var)
sjp.aov1(efc$c12hour,
         efc$e42dep)

# bar-plot, don't use this!
# however, if you dare to, adjust
# 'geom.size'...
sjp.aov1(efc$c12hour,
         as.factor(efc$c172code),
         axisLabels.y = efc.val['c172code'],
         title = efc.var[['c12hour']],
         type = "bars",
         geom.size = 0.5,
         showModelSummary = FALSE)
}
\seealso{
\code{\link{sjs.aov1.levene}}
}

