% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{read_spss}
\alias{read_spss}
\title{Import SPSS dataset as data frame into R}
\usage{
read_spss(path, enc = NA, autoAttachVarLabels = FALSE,
  atomic.to.fac = FALSE, option = NULL)
}
\arguments{
\item{path}{The file path to the SPSS dataset.}

\item{enc}{The file encoding of the SPSS dataset.}

\item{autoAttachVarLabels}{if \code{TRUE}, variable labels will automatically be
attached to each variable as \code{"variable.label"} attribute.
See \code{\link{set_var_labels}} for details.}

\item{atomic.to.fac}{Logical, if \code{TRUE}, factor variables imported from
SPSS (which are imported as \code{\link{atomic}}) will be converted
to \code{\link{factor}}s.}

\item{option}{string, indicating which package will be used to read the SPSS data file.
By default, \code{option = "foreign"}, which means, the \code{read.spss} function
from the \code{foreign} package is used. Use \code{option = "haven"} to
use haven's \code{read_spss} function, which is usually faster, however,
not all string variables may be read properly.}
}
\value{
A data frame containing the SPSS data. retrieve value labels with \code{\link{get_val_labels}}
  and variable labels with \code{\link{get_var_labels}}.
}
\description{
Import data from SPSS, including NA's, value and variable labels.
}
\note{
This is a wrapper function for \code{\link{read.spss}} of the
        \code{foreign} package, using convenient parameter default
        settings. This function attaches value and variable
        labels to the imported variables of the data frame. \cr \cr
       With attached value and variable labels, most functions of this package
       automatically detect labels and uses them as axis, legend or title labels
       in plots (\code{sjp.}-functions) respectively as column or row headers
       in table outputs (\code{sjt.}-functions). Use \code{options(autoSetValueLabels = FALSE)}
       and \code{options(autoSetVariableLabels = FALSE)} to turn off automatic
       label detection.
}
\examples{
# import SPSS data set
# mydat <- read_spss("my_spss_data.sav", enc="UTF-8")

# retrieve variable labels
# mydat.var <- get_var_labels(mydat)

# retrieve value labels
# mydat.val <- get_val_labels(mydat)
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/view_spss/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{get_val_labels}}
           \item \code{\link{get_var_labels}}
           \item \code{\link{to_label}}
           \item \code{\link{to_value}}
           \item \code{\link{to_fac}}
           \item \code{\link{view_spss}}
           }
}

