% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotFrequencies.R
\name{sjp.frq}
\alias{sjp.frq}
\title{Plot frequencies of (count) variables}
\usage{
sjp.frq(varCount, title = "", weightBy = NULL, weightByTitleString = NULL,
  interactionVar = NULL, sort.frq = "none", type = "bars",
  geom.size = 0.7, geom.colors = NULL, axisLabels.x = NULL,
  interactionVarLabels = NULL, axisLimits.y = NULL, breakTitleAt = 50,
  breakLabelsAt = 20, gridBreaksAt = NULL, innerBoxPlotWidth = 0.15,
  innerBoxPlotDotSize = 3, expand.grid = FALSE, showValueLabels = TRUE,
  showCountValues = TRUE, showPercentageValues = TRUE,
  showAxisLabels.x = TRUE, showAxisLabels.y = TRUE, showCI = FALSE,
  error.bar.color = "darkred", showMeanIntercept = FALSE,
  showMeanValue = TRUE, showStandardDeviation = TRUE,
  showNormalCurve = FALSE, showStandardNormalCurve = FALSE,
  adjustNormalCurve.x = FALSE, meanInterceptLineType = 2,
  meanInterceptLineSize = 0.5, normalCurveColor = "red",
  normalCurveSize = 0.8, normalCurveAlpha = 0.4, axisTitle.x = NULL,
  axisTitle.y = NULL, startAxisAt = "auto", hist.skipZeros = FALSE,
  autoGroupAt = NULL, coord.flip = FALSE, labelPos = "outside",
  na.rm = TRUE, printPlot = TRUE)
}
\arguments{
\item{varCount}{The variable which frequencies should be plotted.}

\item{title}{Title of diagram as string. Example: \code{title=c("my title")}.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_var_labels}}) for details).}

\item{weightBy}{A weight factor that will be applied to weight all cases from \code{varCount}.
Must be a vector of same length as \code{varCount}. Default is \code{NULL}, so no weights are used.}

\item{weightByTitleString}{If a weight factor is supplied via the parameter \code{weightBy}, the diagram's title
may indicate this with a remark. Default is \code{NULL}, so the diagram's title will not be modified when
cases are weighted. Use a string as parameter, e.g.: \code{weightByTitleString=" (weighted)"}.}

\item{interactionVar}{An interaction variable which can be used for box plots. Divides the observations in
\code{varCount} into the factors (sub groups) of \code{interactionVar}. Only applies when parameter \code{"type"}
is \code{"box"} or \code{"violin"} (resp. their alternative strings like \code{"boxplot"}, \code{"boxplots"} or \code{"v"}).}

\item{sort.frq}{Determines whether categories on x-axis should be sorted according to the frequencies or not.
Default is \code{"none"}, so categories are not sorted by frequency. Use \code{"asc"} or
\code{"desc"} for sorting categories ascending or descending in relation to the frequencies.}

\item{type}{Specifies the type of distribution plot that will be plotted.
\itemize{
  \item \code{"bar"}, \code{"bars"} or \code{"b"} for simple bars (the default setting).
  \item \code{"dots"} or \code{"dot"} for a dot plot.
  \item \code{"h"}, \code{"hist"} or \code{"histogram"} for a histogram.
  \item \code{"line"}, \code{"lines"} or \code{"l"} for a histogram with filled area with line.
  \item \code{"dens"}, \code{"d"} or \code{"density"} for a density plot.
  \item \code{"box"}, \code{"boxplot"} or \code{"boxplots"} for box plots.
  \item \code{"v"} or \code{"violin"} for violin plots.
  }}

\item{geom.size}{The size of the geoms, depending on the \code{type} of the plot. Note that
bar and bin widths mostly need smaller values than dot sizes (i.e. if \code{type} is
\code{"dots"}).}

\item{geom.colors}{User defined color for geoms, e.g. \code{geom.colors="#0080ff"}.}

\item{axisLabels.x}{Labels for the x-axis breaks.
Example: \code{axisLabels.x=c("Label1", "Label2", "Label3")}.
Note: If you use the \code{\link[sjmisc]{read_spss}} function and the \code{\link[sjmisc]{get_val_labels}} function, you receive a
list object with label string. The labels may also be passed as list object. They will be coerced
to character vector automatically.}

\item{interactionVarLabels}{Labels for the x-axis breaks when having interaction variables included.
These labels replace the \code{axisLabels.x}. Only applies, when using box or violin plots
(i.e. \code{"type"} is \code{"box"} or \code{"violin"}) and \code{interactionVar} is not \code{NULL}.
Example: See \code{axisLabels.x}.}

\item{axisLimits.y}{A numeric vector of length two, defining lower and upper axis limits
of the y scale. By default, this parameter is set to \code{NULL}, i.e. the
y-axis ranges from 0 to required maximum.}

\item{breakTitleAt}{Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{Determines how many chars of the labels are displayed in
one line and when a line break is inserted into the axis labels.}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed.}

\item{innerBoxPlotWidth}{The width of the inner box plot that is plotted inside of violin plots. Only applies
if \code{type} is \code{"violin"}. Default value is 0.15}

\item{innerBoxPlotDotSize}{Size of mean dot insie a violin plot. Applies only when \code{type} is set to \code{"violin"} or \code{"box"}.}

\item{expand.grid}{If \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{showValueLabels}{Whether counts and percentage values should be plotted to each bar. Default
is \code{TRUE}.}

\item{showCountValues}{If \code{TRUE} (default), count values are be plotted to each bar. If \code{FALSE},
count values are removed.}

\item{showPercentageValues}{If \code{TRUE} (default), percentage values are be plotted to each bar, if \code{FALSE},
percentage-values are removed.}

\item{showAxisLabels.x}{Whether x axis labels (category names) should be shown or not.}

\item{showAxisLabels.y}{Whether y axis labels (count values) should be shown or not.}

\item{showCI}{logical, whether or not confidence intervals should be plotted. Only applies to \code{type = "dots"}
or \code{type = "bars"}.}

\item{error.bar.color}{Color of confidence interval bars (error bars). Only applies to \code{type = "bars"}. In case
of dot plots, error bars will have same colors as dots (see \code{geom.colors}).}

\item{showMeanIntercept}{If \code{TRUE}, a vertical line in histograms is drawn to indicate the mean value of the count
variables. Only applies to histogram-charts.}

\item{showMeanValue}{If \code{TRUE} (default value), the mean value is printed to the vertical line that indicates the mean value
of the count variables. Only applies to histogram-charts.}

\item{showStandardDeviation}{If \code{TRUE}, the standard deviation is annotated as shaded rectangle around the mean intercept
line. Only applies to histogram-charts.}

\item{showNormalCurve}{If \code{TRUE}, a normal curve, which is adjusted to the data,
is plotted over the histogram or density plot. Default is
\code{FALSE}. Only applies when histograms or density plots are plotted (see \code{type}).}

\item{showStandardNormalCurve}{If \code{TRUE}, a normal curve, which is not adjusted to the data (thus
representing a "true" standard normal curve, which is, however, still an approximation),
is plotted over the histogram or density plot. Default is \code{FALSE}. Only applies when
histograms or density plots are plotted (see \code{type}).}

\item{adjustNormalCurve.x}{If \code{TRUE} and \code{showStandardNormalCurve} is also \code{TRUE}, the
x-axis-start of the standard normal curve starts with the x-axis limits of the graph. This
is only necessary, if minimum value of \code{varCount} is larger than 0 or 1.}

\item{meanInterceptLineType}{The linetype of the mean intercept line. Only applies to histogram-charts and
when \code{showMeanIntercept} is \code{TRUE}.}

\item{meanInterceptLineSize}{The size of the mean intercept line. Only applies to histogram-charts and when
\code{showMeanIntercept} is \code{TRUE}.}

\item{normalCurveColor}{Specify the color of the normal curve line. Only
applies if \code{showNormalCurve} is \code{TRUE}.}

\item{normalCurveSize}{Specifiy the size of the normal curve line. Only
applies if \code{showNormalCurve} is \code{TRUE}.}

\item{normalCurveAlpha}{Specify the transparancy (alpha value) of the normal curve. Only
applies if \code{showNormalCurve} is \code{TRUE}.}

\item{axisTitle.x}{A label for the x axis. useful when plotting histograms with metric scales where no category labels
are assigned to the x axis. By default, \code{""} is used, i.e. no title
is printed.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_var_labels}}) for details).}

\item{axisTitle.y}{A label for the y axis. useful when plotting histograms with metric scales where no category labels
are assigned to the y axis. By default, \code{""} is used, i.e. no title
is printed.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_var_labels}}) for details).}

\item{startAxisAt}{Determines the first value on the x-axis. By default, this value is set
to \code{"auto"}, i.e. the value range on the x axis starts with the lowest value of \code{varCount}.
If you set \code{startAxisAt} to 1, you may have zero counts if the lowest value of \code{varCount}
is larger than 1 and hence no bars plotted for these values in such cases.}

\item{hist.skipZeros}{If \code{TRUE}, zero counts (categories with no answer) in \code{varCount} are omitted
when drawing histrograms, and the mapping is changed to \code{\link[ggplot2]{stat_bin}}. Only applies to
histograms (see \code{type}). Use this parameter to get identical results to the default
\code{\link[ggplot2]{qplot}} or \code{\link[ggplot2]{geom_histogram}} histogram plots of ggplot. You may need
to adjust the \code{geom.size} parameter for better visual results (which, by ggplot-default, is
1/30 of the x-axis-range).}

\item{autoGroupAt}{A value indicating at which length of unique values of \code{varCount} the variable
is automatically grouped into smaller units (see \code{group_var}). If \code{varCount} has large
numbers of unique values, too many bars for the graph have to be plotted. Hence it's recommended
to group such variables. For example, if \code{autoGroupAt} is 50, i.e. if \code{varCount} has 50 and more unique values
it will be grouped using \code{group_var} with \code{groupsize="auto"} parameter. By default,
the maximum group count is 30. However, if \code{autoGroupAt} is less than 30, \code{autoGroupAt}
groups are built. Default value for \code{autoGroupAt} is \code{NULL}, i.e. auto-grouping is off.}

\item{coord.flip}{If \code{TRUE}, the x and y axis are swapped. Default is \code{FALSE}.}

\item{labelPos}{If \code{coord.flip} is \code{TRUE}, use this parameter to specify value label position.
Can be either \code{"inside"} or \code{"outside"} (default). You may specify
initial letter only. If \code{coord.flip} is \code{FALSE}, this parameter will
be ignored.}

\item{na.rm}{If \code{TRUE}, missings are not included in the frequency calculation and diagram plot.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{mydf}).
}
\description{
Plot frequencies of a (count) variable as bar graph, histogram,
               box plot etc. using ggplot.
}
\note{
This function only works with variables with integer values, i.e. scales / centred variables
        with decimales may result in unexpected behaviour.
}
\examples{
# ---------------
# boxplot
# ---------------
sjp.frq(ChickWeight$weight, type="box")

# ---------------
# histogram
# ---------------
sjp.frq(discoveries, type="hist", showMeanIntercept=TRUE)
# histogram with minimal theme and w/o labels
sjp.frq(discoveries, type="hist",
        showMeanIntercept=TRUE,
        showValueLabels=FALSE)

# ---------------
# violin plot
# ---------------
sjp.frq(ChickWeight$weight, type="v")

# ---------------
# bar plot
# ---------------
sjp.frq(ChickWeight$Diet)

# ---------------
# bar plot with EUROFAMCARE sample dataset
# dataset was importet from an SPSS-file, using:
# efc <- read_spss("efc.sav", enc="UTF-8")
# ---------------
library(sjmisc)
data(efc)
efc.val <- get_val_labels(efc)
efc.var <- get_var_labels(efc)
# you may use sjp.setTheme here to change axis textangle
sjp.frq(as.factor(efc$e15relat),
        title=efc.var[['e15relat']],
        axisLabels.x=efc.val['e15relat'])

# bar plot with EUROFAMCARE sample dataset
# grouped variable
ageGrp <- group_var(efc$e17age)
ageGrpLab <- group_labels(efc$e17age)
sjp.frq(ageGrp,
        title=efc.var[['e17age']],
        axisLabels.x=ageGrpLab)

# ---------------
# box plots with interaction variable
# the following example is equal to the function call
# sjp.grpfrq(efc$e17age, efc$e16sex, type="box")
# ---------------
sjp.frq(efc$e17age,
        title=paste(efc.var[['e17age']], "by", efc.var[['e16sex']]),
        interactionVar=efc$e16sex,
        interactionVarLabels=efc.val['e16sex'],
        type="box")

# -------------------------------------------------
# auto-detection of value labels and variable names
# -------------------------------------------------
efc <- set_var_labels(efc, get_var_labels(efc))

# negative impact scale, ranging from 7-28, assuming that
# variable scale (lowest value) starts with 1
sjp.frq(efc$neg_c_7, startAxisAt=1)

# negative impact scale, ranging from 7-28, using
# automatic detection of start index of x-axis
sjp.frq(efc$neg_c_7)

# -------------------------------------------------
# plotting confidence intervals
# -------------------------------------------------
sjp.frq(efc$e15relat,
        type = "dots",
        showCI = TRUE,
        sort.frq = "desc",
        geom.size = 3,
        coord.flip = TRUE)

# -------------------------------------------------
# Simulate ggplot-default histogram, using "hist.skipZeros"
# and adjusted "geom.size".
# -------------------------------------------------
sjp.frq(efc$c160age,
        type = "h",
        hist.skipZeros = TRUE,
        geom.size = 1)
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjp.frq/}{sjPlot manual: sjp.frq}
           \item \code{\link{sjt.frq}}
         }
}

