% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model.R
\name{plot_model}
\alias{plot_model}
\alias{get_model_data}
\title{Plot regression models}
\usage{
plot_model(model, type = c("est", "re", "eff", "pred", "int", "std", "std2",
  "slope", "resid", "diag"), transform, terms = NULL, sort.est = NULL,
  rm.terms = NULL, group.terms = NULL, order.terms = NULL,
  pred.type = c("fe", "re"), mdrt.values = c("minmax", "meansd", "zeromax",
  "quart", "all"), ri.nr = NULL, title = NULL, axis.title = NULL,
  axis.labels = NULL, wrap.title = 50, wrap.labels = 25,
  axis.lim = NULL, grid.breaks = NULL, ci.lvl = NULL, colors = "Set1",
  show.intercept = FALSE, show.values = FALSE, show.p = TRUE,
  show.data = FALSE, value.offset = NULL, value.size, digits = 2,
  dot.size = NULL, line.size = NULL, vline.color = NULL, grid,
  case = "parsed", auto.label = TRUE, bpe = "median",
  bpe.style = "line", ...)

get_model_data(model, type = c("est", "re", "eff", "pred", "int", "std",
  "std2", "slope", "resid", "diag"), transform, terms = NULL,
  sort.est = NULL, rm.terms = NULL, group.terms = NULL,
  order.terms = NULL, pred.type = c("fe", "re"), ri.nr = NULL,
  ci.lvl = NULL, colors = "Set1", grid, case = "parsed", digits = 2,
  ...)
}
\arguments{
\item{model}{A regression model object. Depending on the \code{type}, many
kinds of models are supported, e.g. from packages like \pkg{stats},
\pkg{lme4}, \pkg{nlme}, \pkg{rstanarm}, \pkg{survey}, \pkg{glmmTMB},
\pkg{MASS}, \pkg{brms} etc.}

\item{type}{Type of plot. There are three groups of plot-types:
\cr \cr
\emph{Coefficients}
\describe{
  \item{\code{type = "est"}}{Forest-plot of estimates. If the fitted model only contains one predictor, slope-line is plotted.}
  \item{\code{type = "re"}}{For mixed effects models, plots the random effects.}
  \item{\code{type = "std"}}{Forest-plot of standardized beta values.}
  \item{\code{type = "std2"}}{Forest-plot of standardized beta values, however, standardization is done by dividing by two sd (see 'Details').}
}
\emph{Marginal Effects}
\describe{
  \item{\code{type = "pred"}}{Predicted values (marginal effects) for specific model terms. See \code{\link[ggeffects]{ggpredict}} for details.}
  \item{\code{type = "eff"}}{Similar to \code{type = "pred"}, however, discrete predictors are held constant at their proportions (not reference level). See \code{\link[ggeffects]{ggeffect}} for details.}
  \item{\code{type = "int"}}{Marginal effects of interaction terms in \code{model}.}
}
\emph{Model diagnostics}
\describe{
  \item{\code{type = "slope"}}{Slope of coefficients for each single predictor, against the response (linear relationship between each model term and response).}
  \item{\code{type = "resid"}}{Slope of coefficients for each single predictor, against the residuals (linear relationship between each model term and residuals).}
  \item{\code{type = "diag"}}{Check model assumptions.}
}}

\item{transform}{A character vector, naming a function that will be applied
on estimates and confidence intervals. By default, \code{transform} will
automatically use \code{"exp"} as transformation for applicable classes
of \code{model} (e.g. logistic or poisson regression). Estimates of linear
models remain untransformed. Use \code{NULL} if you want the raw, non-transformed
estimates.}

\item{terms}{Character vector with the names of those terms from \code{model}
that should be plotted. This argument depends on the plot-type:
\describe{
  \item{\emph{Coefficients}}{
    Select terms that should be plotted. All other term are removed
    from the output.
  }
  \item{\emph{Marginal Effects}}{
    Here \code{terms} indicates for which terms marginal effects
    should be displayed. At least one term is required to calculate
    effects, maximum length is three terms, where the second and
    third term indicate the groups, i.e. predictions of first term
    are grouped by the levels of the second (and third) term. \code{terms}
    may also indicate higher order terms (e.g. interaction terms).
    Indicating levels in square brackets allows for selecting only
    specific groups. Term name and levels in brackets must be separated
    by a whitespace character, e.g. \code{terms = c("age", "education [1,3]")}.
    For more details, see \code{\link[ggeffects]{ggpredict}}.
  }
}}

\item{sort.est}{Determines in which way estimates are sorted in the plot:
\itemize{
  \item If \code{NULL} (default), no sorting is done and estimates are sorted in the same order as they appear in the model formula.
  \item If \code{TRUE}, estimates are sorted in descending order, with highedt estimate at the top.
  \item If \code{sort.est = "sort.all"}, estimates are re-sorted for each coefficient (only applies if \code{type = "re"} and \code{grid = FALSE}), i.e. the estimates of the random effects for each predictor are sorted and plotted to an own plot.
  \item If \code{type = "re"}, specify a predictor's / coefficient's name to sort estimates according to this random effect.
}}

\item{rm.terms}{Character vector with names that indicate which terms should
be removed from the plot. Counterpart to \code{terms}.
\code{rm.terms = "t_name"} would remove the term \emph{t_name}.
Default is \code{NULL}, i.e. all terms are used. Note that this
argument does not apply to \emph{Marginal Effects} plots.}

\item{group.terms}{Numeric vector with group indices, to group coefficients.
Each group of coefficients gets its own color (see 'Examples').}

\item{order.terms}{Numeric vector, indicating in which order the coefficients
should be plotted. See examples in
\href{../doc/plot_model_estimates.html}{this package-vignette}.}

\item{pred.type}{Character, only applies for \emph{Marginal Effects} plots
with mixed effects models. Indicates whether predicted values should be
conditioned on random effects (\code{pred.type = "re"}) or fixed effects
only (\code{pred.type = "fe"}, the default).}

\item{mdrt.values}{Indicates which values of the moderator variable should be
used when plotting interaction terms (i.e. \code{type = "int"}).
\describe{
  \item{\code{"minmax"}}{(default) minimum and maximum values (lower and upper bounds) of the moderator are used to plot the interaction between independent variable and moderator(s).}
  \item{\code{"meansd"}}{uses the mean value of the moderator as well as one standard deviation below and above mean value to plot the effect of the moderator on the independent variable (following the convention suggested by Cohen and Cohen and popularized by Aiken and West, i.e. using the mean, the value one standard deviation above, and the value one standard deviation below the mean as values of the moderator, see \href{http://www.theanalysisfactor.com/3-tips-interpreting-moderation/}{Grace-Martin K: 3 Tips to Make Interpreting Moderation Effects Easier}).}
  \item{\code{"zeromax"}}{is similar to the \code{"minmax"} option, however, \code{0} is always used as minimum value for the moderator. This may be useful for predictors that don't have an empirical zero-value, but absence of moderation should be simulated by using 0 as minimum.}
  \item{\code{"quart"}}{calculates and uses the quartiles (lower, median and upper) of the moderator value.}
  \item{\code{"all"}}{uses all values of the moderator variable.}
}}

\item{ri.nr}{Numeric vector. If \code{type = "re"} and fitted model has more
than one random intercept, \code{ri.nr} indicates which random effects of
which random intercept (or: which list elements of \code{\link[lme4]{ranef}})
will be plotted. Default is \code{NULL}, so all random effects will be
plotted.}

\item{title}{Character vector, used as plot title. By default,
\code{\link[sjlabelled]{get_dv_labels}} is called to retrieve the
label of the dependent variable, which will be used as title. Use
\code{title = ""} to remove title.}

\item{axis.title}{Character vector of length one or two (depending on
the plot function and type), used as title(s) for the x and y axis.
If not specified, a default labelling  is chosen. \strong{Note:}
Some plot types may not support this argument sufficiently. In such
cases, use the returned ggplot-object and add axis titles manually with
\code{\link[ggplot2]{labs}}. Use \code{axis.title = ""} to remove axis
titles.}

\item{axis.labels}{Character vector with labels for the model terms, used as
axis labels. By default, \code{\link[sjlabelled]{get_term_labels}} is
called to retrieve the labels of the coefficients, which will be used as
axis labels. Use \code{axis.labels = ""} or \code{auto.label = FALSE}
to use the variable names as labels instead.}

\item{wrap.title}{Numeric, determines how many chars of the plot title are
displayed in one line and when a line break is inserted.}

\item{wrap.labels}{Numeric, determines how many chars of the value, variable
or axis labels are displayed in one line and when a line break is inserted.}

\item{axis.lim}{Numeric vector of length 2, defining the range of the plot
axis. Depending on plot-type, may effect either x- or y-axis. For
\emph{Marginal Effects} plots, \code{axis.lim} may also be a list of two
vectors of length 2, defining axis limits for both the x and y axis.}

\item{grid.breaks}{Numeric; sets the distance between breaks for the axis,
i.e. at every \code{grid.breaks}'th position a major grid is plotted.}

\item{ci.lvl}{Numeric, the level of the confidence intervals (error bars).
Use \code{ci.lvl = NA} to remove error bars. For \code{stanreg}-models,
\code{ci.lvl} defines the (outer) probability for the \code{\link[sjstats]{hdi}}
(High Density Interval) that is plotted. By default, \code{stanreg}-models
are printed with two intervals: the "inner" interval, which defaults to
the 50\%-HDI; and the "outer" interval, which defaults to the 89\%-HDI.
\code{ci.lvl} affects only the outer interval in such cases. See
\code{prob.inner} and \code{prob.outer} under the \code{...}-argument
for more details.}

\item{colors}{May be a character vector of color values in hex-format, valid
color value names (see \code{demo("colors")}) or a name of a
\href{http://colorbrewer2.org}{color brewer} palette. Following options
are valid for the \code{colors} argument:
\itemize{
  \item If not specified, a default color brewer palette will be used, which is suitable for the plot style.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{"bw"}, and plot-type is a line-plot, the plot is black/white and uses different line types to distinguish groups (see \href{../doc/blackwhitefigures.html}{this package-vignette}).
  \item If \code{colors} is any valid color brewer palette name, the related palette will be used. Use \code{\link[RColorBrewer]{display.brewer.all}} to view all available palette names.
  \item If \pkg{wesanderson} is installed, you may also specify a name of a palette from that package.
  \item Else specify own color values or names as vector (e.g. \code{colors = "#00ff00"}).
}}

\item{show.intercept}{Logical, if \code{TRUE}, the intercept of the fitted
model is also plotted. Default is \code{FALSE}. If \code{transform = "exp"},
please note that due to exponential transformation of estimates, the
intercept in some cases is non-finite and the plot can not be created.}

\item{show.values}{Logical, whether values should be plotted or not.}

\item{show.p}{Logical, adds asterisks that indicate the significance level
of estimates to the value labels.}

\item{show.data}{Logical, for \emph{Marginal Effects} plots, also plots
the raw data points.}

\item{value.offset}{Numeric, offset for text labels to adjust their position
relative to the dots or lines.}

\item{value.size}{Numeric, indicates the size of value labels. Can be used
for all plot types where the argument \code{show.values} is applicable,
e.g. \code{value.size = 4}.}

\item{digits}{Numeric, amount of digits after decimal point when rounding
estimates or values.}

\item{dot.size}{Numeric, size of the dots that indicate the point estimates.}

\item{line.size}{Numeric, size of the lines that indicate the error bars.}

\item{vline.color}{Color of the vertical "zero effect" line. Default color
is inherited from the current theme.}

\item{grid}{Logical, if \code{TRUE}, multiple plots are plotted as grid layout.}

\item{case}{Desired target case. Labels will automatically converted into the
specified character case. See \code{\link[snakecase]{to_any_case}} for
more details on this argument.}

\item{auto.label}{Logical, if \code{TRUE} (the default), plot-labels are based
on value and variable labels, if the data is labelled. See
\code{\link[sjlabelled]{get_label}} and \code{\link[sjlabelled]{get_term_labels}}
for details.}

\item{bpe}{For \strong{Stan}-models (fitted with the \pkg{rstanarm}- or
\pkg{brms}-package), the Bayesian point estimate is, by default, the
median of the posterior distribution. Use \code{bpe} to define other
functions to calculate the Bayesion point estimate. \code{bpe} needs to
be a character naming the specific function, which is passed to the
\code{fun}-argument in \code{\link[sjstats]{typical_value}}. So,
\code{bpe = "mean"} would calculate the mean value of the posterior
distribution.}

\item{bpe.style}{For \strong{Stan}-models (fitted with the \pkg{rstanarm}- or
\pkg{brms}-package), the Bayesian point estimate is indicated as a small,
vertical line by default. Use \code{bpe.style = "dot"} to plot a dot
instead of a line for the point estimate.}

\item{...}{Other arguments, passed down to various functions. Here is a list
of supported arguments and their description in detail.
\describe{
  \item{\code{prob.inner} and \code{prob.outer}}{
    For \strong{Stan}-models (fitted with the \pkg{rstanarm}- or
    \pkg{brms}-package) and coefficients plot-types, you can specify
    numeric values between 0 and 1 for \code{prob.inner} and
    \code{prob.outer}, which will then be used as inner and outer
    probabilities for the uncertainty intervals (HDI). By default, the
    inner probability is 0.5 and the outer probability is 0.89 (unless
    \code{ci.lvl} is specified - in this case, \code{ci.lvl} is used as
    outer probability).
  }
  \item{\code{size.inner}}{
    For \strong{Stan}-models and \emph{Coefficients} plot-types, you
    can specify the width of the bar for the inner probabilities.
    Default is \code{0.1}.
  }
  \item{\code{width}, \code{alpha} and \code{scale}}{
    Passed down to \code{geom_errorbar()} or \code{geom_density_ridges()},
    for forest or diagnostic plots; or passed down to
    \code{\link[ggeffects]{plot.ggeffects}} for \emph{Marginal Effects} plots.
  }
  \item{\code{show.loess}}{
    Logical, for diagnostic plot-types \code{"slope"} and \code{"resid"},
    adds (or hides) a loess-smoothed line to the plot.
  }
  \item{\emph{Marginal Effects} plot-types}{
    When plotting marginal effects, arguments are also passed down to
    \code{\link[ggeffects]{ggpredict}}, \code{\link[ggeffects]{ggeffect}}
    or \code{\link[ggeffects]{plot.ggeffects}}.
  }
}}
}
\value{
Depending on the plot-type, \code{plot_model()} returns a
  \code{ggplot}-object or a list of such objects. \code{get_model_data}
  returns the associated data with the plot-object as tidy data frame,
  or (depending on the plot-type) a list of such data frames.
}
\description{
\code{plot_model()} creates plots from regression models, either
   estimates (as so-called forest or dot whisker plots) or marginal effects.
}
\details{
\code{get_model_data} simply calls \code{plot_model()} and returns
  the data from the ggplot-object. Hence, it is rather inefficient and should
  be used as alternative to \pkg{brooms} \code{tidy()}-function only in
  specific situations.
  \cr \cr
  Some notes on the different plot-types:
  \describe{
    \item{\code{type = "std2"}}{
      Plots standardized beta values, however, standardization follows
      Gelman's (2008) suggestion, rescaling the estimates by dividing them
      by two standard deviations instead of just one. Resulting coefficients
      are then directly comparable for untransformed binary predictors. This
      standardization uses the \code{\link[arm]{standardize}}-function from
      the \pkg{arm}-package.
    }
    \item{\code{type = "pred"}}{
      Plots marginal effects. Simply wraps \code{\link[ggeffects]{ggpredict}}.
    }
    \item{\code{type = "eff"}}{
      Plots marginal effects. Simply wraps \code{\link[ggeffects]{ggeffect}}.
    }
    \item{\code{type = "int"}}{
      A shortcut for marginal effects plots, where interaction terms are
      automatically detected and used as `terms`-argument. Furthermore,
      if the moderator variable (the second - and third - term in an interaction)
      is continuous, \code{type = "int"} automatically chooses useful values
      based on the `mdrt.values`-argument, which are passed to `terms`. Then,
      \code{\link[ggeffects]{ggpredict}} is called. \code{type = "int"} plots
      the interaction term that appears first in the formula along the x-axis,
      while the second (and possibly third) variable in an interaction is
      used as grouping factor(s) (moderating variable). Use \code{type = "pred"}
      or \code{type = "eff"} and specify a certain order in the `terms`-argument
      to indicate which variable(s) should be used as moderator.
    }
  }
}
\note{
\code{plot_model()} replaces the functions \code{sjp.lm}, \code{sjp.glm},
  \code{sjp.lmer}, \code{sjp.glmer} and \code{sjp.int}. These are becoming
  softly deprecated and will be removed in a future update.
}
\examples{
# prepare data
library(sjmisc)
data(efc)
efc <- to_factor(efc, c161sex, e42dep, c172code)
m <- lm(neg_c_7 ~ pos_v_4 + c12hour + e42dep + c172code, data = efc)

# simple forest plot
plot_model(m)

# grouped coefficients
plot_model(m, group.terms = c(1, 2, 3, 3, 3, 4, 4))

# multiple plots, as returned from "diagnostic"-plot type,
# can be arranged with 'plot_grid()'
\dontrun{
p <- plot_model(m, type = "diag")
plot_grid(p)}

# plot random effects
library(lme4)
m <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
plot_model(m, type = "re")

# plot marginal effects
plot_model(m, type = "eff", terms = "Days")

# plot interactions
\dontrun{
m <- glm(
  tot_sc_e ~ c161sex + c172code * neg_c_7,
  data = efc,
  family = poisson()
)
# type = "int" automatically selects groups for continuous moderator
# variables - see argument 'mdrt.values'. The following function call is
# identical to:
# plot_model(m, type = "pred", terms = c("c172code", "neg_c_7 [7,28]"))
plot_model(m, type = "int")
# switch moderator
plot_model(m, type = "pred", terms = c("neg_c_7", "c172code"))
# same as
# ggeffects::ggpredict(m, terms = c("neg_c_7", "c172code"))}

# plot Stan-model
\dontrun{
if (require("rstanarm")) {
  data(mtcars)
  m <- stan_glm(mpg ~ wt + am + cyl + gear, data = mtcars, chains = 1)
  plot_model(m, bpe.style = "dot")
}}

}
\references{
Gelman A (2008) "Scaling regression inputs by dividing by two standard deviations." \emph{Statistics in Medicine 27: 2865–2873.} \url{http://www.stat.columbia.edu/~gelman/research/published/standardizing7.pdf}
}
\seealso{
Package-vignette about \href{../doc/plot_model_estimates.html}{plot_model()}.
}
