% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjplot_themes.R
\name{sjPlot-themes}
\alias{sjPlot-themes}
\alias{theme_sjplot}
\alias{theme_sjplot2}
\alias{theme_blank}
\alias{theme_538}
\alias{font_size}
\alias{label_angle}
\alias{legend_style}
\alias{scale_color_sjplot}
\alias{scale_fill_sjplot}
\alias{sjplot_pal}
\alias{show_sjplot_pals}
\alias{css_theme}
\title{Modify plot appearance}
\usage{
theme_sjplot(base_size = 12, base_family = "")

theme_sjplot2(base_size = 12, base_family = "")

theme_blank(base_size = 12, base_family = "")

theme_538(base_size = 12, base_family = "")

font_size(title, axis_title.x, axis_title.y, labels.x, labels.y, offset.x,
  offset.y, base.theme)

label_angle(angle.x, angle.y, base.theme)

legend_style(inside, pos, justify, base.theme)

scale_color_sjplot(palette = "metro ui", discrete = TRUE, reverse = FALSE,
  ...)

scale_fill_sjplot(palette = "metro ui", discrete = TRUE, reverse = FALSE,
  ...)

sjplot_pal(palette = "metro ui", n = NULL)

show_sjplot_pals()

css_theme(css.theme = "regression")
}
\arguments{
\item{base_size}{Base font size.}

\item{base_family}{Base font family.}

\item{title}{Font size for plot titles.}

\item{axis_title.x}{Font size for x-axis titles.}

\item{axis_title.y}{Font size for y-axis titles.}

\item{labels.x}{Font size for x-axis labels.}

\item{labels.y}{Font size for y-axis labels.}

\item{offset.x}{Offset for x-axis titles.}

\item{offset.y}{Offset for y-axis titles.}

\item{base.theme}{Optional ggplot-theme-object, which is needed in case multiple
functions should be combined, e.g. \code{theme_sjplot() + label_angle()}.
In such cases, use \code{label_angle(base.theme = theme_sjplot())}.}

\item{angle.x}{Angle for x-axis labels.}

\item{angle.y}{Angle for y-axis labels.}

\item{inside}{Logical, use \code{TRUE} to put legend inside the plotting area.
See also \code{pos}.}

\item{pos}{Position of the legend, if a legend is drawn.
\describe{
  \item{\emph{Legend outside plot}}{
    Use \code{"bottom"}, \code{"top"}, \code{"left"} or \code{"right"}
    to position the legend above, below, on the left or right side
    of the diagram.
  }
  \item{\emph{Legend inside plot}}{
    If \code{inside = TRUE}, legend can be placed inside
    plot. Use \code{"top left"}, \code{"top right"}, \code{"bottom left"}
    and \code{"bottom right"} to position legend in any of these corners,
    or a two-element numeric vector with values from 0-1. See also
    \code{inside}.
  }
}}

\item{justify}{Justification of legend, relative to its position (\code{"center"} or
two-element numeric vector with values from 0-1.}

\item{palette}{Character name of color palette.}

\item{discrete}{Logical, if \code{TRUE}, a discrete colour palette is returned.
Else, a gradient palette is returned, where colours of the requested palette
are interpolated using \code{\link[grDevices]{colorRampPalette}}.}

\item{reverse}{Logical, if \code{TRUE}, order of returned colours is reversed.}

\item{...}{Further arguments passed down to ggplot's \code{scale()}-functions.}

\item{n}{Numeric, number of colors to be returned. By default, the complete
colour palette is returned.}

\item{css.theme}{Name of the CSS pre-set theme-style. Can be used for table-functions.}
}
\description{
Set default plot themes, use pre-defined color scales or modify
  plot or table appearance.
}
\details{
When using the \code{colors} argument in function calls (e.g.
  \code{plot_model()}) or when calling one of the predefined scale-functions
  (e.g. \code{scale_color_sjplot()}), there are pre-defined colour palettes
  in this package: \code{"aqua"}, \code{"warm"}, \code{"dust"}, \code{"blambus"},
  \code{"simply"}, \code{"us"}, \code{"deep reefs"}, \code{"breakfast club"}
  and \code{"metro ui"}. Use \code{show_sjplot_pals()} to show all available
  colour palettes.
}
\examples{
# prepare data
library(sjmisc)
data(efc)
efc <- to_factor(efc, c161sex, e42dep, c172code)
m <- lm(neg_c_7 ~ pos_v_4 + c12hour + e42dep + c172code, data = efc)

# create plot-object
p <- plot_model(m)

# change theme
p + theme_sjplot()

# change font-size
p + font_size(axis_title.x = 30)

# apply color theme
p + scale_color_sjplot()

# show all available colour palettes
show_sjplot_pals()

# get colour values from specific palette
sjplot_pal(pal = "breakfast club")

}
