% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{set_var_labels}
\alias{set_var_labels}
\title{Attach variable label(s) to a single variable or data frame}
\usage{
set_var_labels(x, lab, attr.string = NULL)
}
\arguments{
\item{x}{A single variable (vector) or data frame with variables.}

\item{lab}{If \code{x} is a vector (single variable), use a single character string with
the variable label for \code{x}. If \code{x} is a \code{\link{data.frame}}, use a
vector with character labels of same length as \code{ncol(x)}.}

\item{attr.string}{The attribute string for the variable label. To ensure
compatibility to the \code{foreign}-package, use the default string
\code{"variable.label"}. If you want to save data with the \code{haven}
package, use \code{attr.string = "label"}. There is a wrapper function
\code{\link{write_spss}} to save SPSS files, so you don't need to take
care of this.}
}
\value{
\code{x}, with attached variable label attribute(s), which contains the
          variable name(s).
}
\description{
This function sets variable labels to a single variable or to
               a set of variables in a data frame. To each variable, the
               attribute \code{"label"} or \code{"variable.label"} with the related variable
               name is attached. Most of this package's functions can automatically
               retrieve the variable name to use it as axis labels or plot title
               (see details).
}
\details{
This package can add (and read) value and variable labels either in \code{foreign}
           package style (\emph{value.labels} and \emph{variable.label}) or in
           \code{haven} package style (\emph{labels} and \emph{label}). By default,
           the \code{haven} package style is used. The \code{sjPlot} package accesses
           these attributes to automatically read label attributes for labelling
           axes categories and titles or table rows and columns. \cr Furthermore,
           value and variable labels are used when saving data, e.g. to SPSS
           (see \code{\link{write_spss}}), which means that the written SPSS file
           contains proper labels for each variable. \cr
           You can set a default label style via \code{options(value_labels = "haven")}
           or \code{options(value_labels = "foreign")}.
}
\note{
With attached value and variable labels, most functions of this package
      automatically detect labels and uses them as axis, legend or title labels
      in plots (\code{sjp.}-functions) respectively as column or row headers
      in table outputs (\code{sjt.}-functions). Use \code{options(autoSetValueLabels = FALSE)}
      and \code{options(autoSetVariableLabels = FALSE)} to turn off automatic
      label detection.
}
\examples{
# sample data set, imported from SPSS. Variable labels are attached
# as attribute to the data frame (so variables currently don't have this attribute)
data(efc)
# get variable labels
variable.labels <- get_var_labels(efc)
# set variable labels as attribute to each single variable of data frame
efc <- set_var_labels(efc, variable.labels)

\dontrun{
sjt.frq(efc$e42dep)
sjt.frq(data.frame(efc$e42dep, efc$e16sex))}

# ---------------------------------------------
# manually set value and variable labels
# ---------------------------------------------
dummy <- sample(1:4, 40, replace=TRUE)
dummy <- set_val_labels(dummy, c("very low", "low", "mid", "hi"))
dummy <- set_var_labels(dummy, "Dummy-variable")
# auto-detection of value labels by default, auto-detection of
# variable labels if parameter "title" set to NULL.
\dontrun{
sjp.frq(dummy, title = NULL)}
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/view_spss/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{get_var_labels}}
           }
}

