% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust.R
\name{robust}
\alias{robust}
\title{Robust standard errors for regression models}
\usage{
robust(x, vcov = c("HC3", "const", "HC", "HC0", "HC1", "HC2", "HC4", "HC4m",
  "HC5"), conf.int = FALSE, exponentiate = FALSE)
}
\arguments{
\item{x}{A fitted model of any class that is supported by the \code{coeftest()}-function.}

\item{vcov}{Character vector, specifying the estimation type for the
heteroskedasticity-consistent covariance matrix estimation
(see \code{\link[sandwich]{vcovHC}} for details).}

\item{conf.int}{Logical, \code{TRUE} if confidence intervals based on robust
standard errors should be included.}

\item{exponentiate}{Logical, whether to exponentiate the coefficient estimates
and confidence intervals (typical for logistic regression).}
}
\value{
A summary of the model, including estimates, robust standard error,
          p-value and - optionally - the confidence intervals.
}
\description{
Compute robust standard error for regression models. This method
               wraps the \code{\link[lmtest]{coeftest}}-function with
               robust covariance matrix estimators based on the
               \code{\link[sandwich]{vcovHC}}-function, and returns the
               result as tidy data frame.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c160age + c12hour + c161sex + c172code, data = efc)
summary(fit)
robust(fit)

confint(fit)
robust(fit, conf.int = TRUE)
robust(fit, vcov = "HC1", conf.int = TRUE) # "HC1" should be Stata default

library(sjmisc)
# dichtomozize service usage by "service usage yes/no"
efc$services <- sjmisc::dicho(efc$tot_sc_e, dich.by = 0)
fit <- glm(services ~ neg_c_7 + c161sex + e42dep,
           data = efc, family = binomial(link = "logit"))

robust(fit)
robust(fit, conf.int = TRUE, exponentiate = TRUE)

}

