% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_skeleton.R
\name{print_skeleton}
\alias{print_skeleton}
\title{Print folder structures}
\usage{
print_skeleton(path = ".", comments = NULL, folders = NULL)
}
\arguments{
\item{path}{path to the directory to be printed. Default is current directory.}

\item{comments}{A character string with the comments to be added to each folder in the graphical representation of the folder skeleton printed on the console.}

\item{folders}{A character vector including the name of the sub-directories of the project.}
}
\value{
The folder skeleton is printed in the console.
}
\description{
\code{print_skeleton} prints the folder structure of a research compendium.
}
\details{
The function prints the folder structure of an existing project.
}
\examples{
{
data(compendiums)

make_compendium(name = "my_other_compendium", path = tempdir(), format = "basic")

print_skeleton(path = file.path(tempdir(), "mycompendium"))
}

}
\references{
{
Araya-Salas, M., Arriaga, A. (2023), sketchy: research compendiums for data analysis in R. R package version 1.0.3.
}
}
\seealso{
\code{\link{compendiums}}, \code{\link{make_compendium}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
