% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{skipTrack.simulate}
\alias{skipTrack.simulate}
\title{Simulate user-tracked menstrual cycle data for multiple individuals}
\usage{
skipTrack.simulate(
  n,
  model = c("skipTrack", "li", "mixture"),
  skipProb = NULL,
  maxCycles = length(skipProb),
  trueBetas = NULL,
  trueGammas = NULL,
  overlap = 0
)
}
\arguments{
\item{n}{Number of individuals to simulate data for.}

\item{model}{model for data simulation. Can be a character ('skipTrack', 'li', 'mixture') or a custom function.}

\item{skipProb}{Vector of probabilities for number of true cycles per tracked cycle. For
example, (.7, .2, .1) means that 70\% of observed cycles will contain one true cycle, 20\%
will contain 2 true cycles and 10\% will contain 3 true cycles. Default is NULL. If
model == 'li', skipProb values are set and user input will be ignored.}

\item{maxCycles}{Maximum number of cycles for generating skip cycles. Default is the length of skipProb.
If model == 'li', this must be specified; if model == 'skipTrack' or 'mixture', leave as default.}

\item{trueBetas}{Optional. True values for the mean regression coefficients (not counting intercept which is automatic based on the model).}

\item{trueGammas}{Optional. True values for the precision regression coefficients (not counting intercept which is automatic based on the model). Precision covariates not available for model == 'li'.}

\item{overlap}{Optional. Number of (non-intercept) columns shared between X and Z. Columns are shared from left to right.}
}
\value{
A list containing:
\describe{
\item{'Y'}{Tracked cycles from the simulated data.}
\item{'cluster'}{Individual identifiers from the simulated data.}
\item{'X'}{Covariate matrix for Betas (mean cycle length).}
\item{'Z'}{Covariate matrix for Gammas (regularity).}
\item{'Beta'}{True beta coefficients.}
\item{'Gamma'}{True gamma coefficients.}
\item{'NumTrue'}{Number of true cycles in each tracked cycle. Order matches Y.}
\item{'Underlying'}{Subset of the simulated data containing individual level information. For 'skipTrack' - individual mean and precision for log(cycle lengths), for 'li' - individual mean for cycle lengths, for 'mixture' - individual mean for cycle lengths}
}
}
\description{
This function generates synthetic data for user-tracked menstrual cycles given a generative model,
skip probabilities, maximum cycles and covariates (depending on the model).
It supports built-in models ('skipTrack', 'li', 'mixture') and custom models written as functions.
}
\examples{
# Example simulation from the SkipTrack model
resultSt <- skipTrack.simulate(1000, model = 'skipTrack', skipProb = c(.7, .2, .1))
hist(resultSt$Y, breaks = 5:200)

# Example simulation from the Li model
resultLi <- skipTrack.simulate(1000, model = 'li', maxCycles = 3)
hist(resultLi$Y, breaks = 5:200)

#Example simulation from the mixture model
resultMix <- skipTrack.simulate(1000, model = 'mixture', skipProb = c(.7, .2, .1))
hist(resultMix$Y, breaks = 5:200)

}
\references{
Li, Kathy, et al. "A predictive model for next cycle start date that accounts for adherence in menstrual self-tracking." Journal of the American Medical Informatics Association 29.1 (2022): 3-11.
}
\seealso{
\code{\link{stSim}}, \code{\link{liSim}}, \code{\link{mixSim}}
}
