% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_exponential_anticoef.R
\name{gen_exponential_anticoef}
\alias{gen_exponential_anticoef}
\title{Generates Exponential Anticipated Coefficients}
\usage{
gen_exponential_anticoef(anticoef, mean_low, mean_high)
}
\arguments{
\item{anticoef}{input anticipated coefficients}

\item{mean_low}{The low value of the mean value (= 1/rate)}

\item{mean_high}{The high value of the mean value (= 1/rate)}
}
\value{
Anticipated coefficients.
}
\description{
Generates Exponential Anticipated Coefficients
Solves the exponential link function
mean = exp(beta0 + beta1 * x)
such that mean = mean_low when x = -1, and mean = mean_high when x = +1.
Equivalently, solves this set of equations for beta0 and beta1:
mean_low = exp(beta0 - beta1)
mean_high = exp(beta0 + beta1)
}
\keyword{internal}
