## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=FALSE---------------------------------------------------------------
#  ctl    <- c(4.17, 5.58, 5.18, 6.11, 4.50, 4.61, 5.17, 4.53, 5.33, 5.14)
#  trt    <- c(4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69)
#  group  <- gl(2, 10, 20, labels = c("Ctl", "Trt"))
#  weight <- c(ctl, trt)
#  
#  # pass a message to Slack channel 'general'
#  register_onexit(lm, "bazinga!", channel = "#general")
#  
#  lm.D9 <- slack_lm(weight ~ group)
#  
#  # test that output keeps inheritance
#  summary(lm.D9)
#  
#  # pass a message to Slack channel 'general' with a header message to begin output
#  register_onexit(
#    lm, "bazinga!",
#    channel = "#general",
#    header_msg = "This is a message to begin"
#  )
#  
#  lm.D9 <- slack_lm(weight ~ group)
#  
#  # onexit with an expression that calls lm.plot
#  register_onexit(
#    lm,
#    {
#      par(mfrow = c(2, 2), oma = c(0, 0, 2, 0))
#      plot(z) # z is the internal output of stats::lm()
#    },
#    channel = "#general",
#    header_msg = "This is a plot just for this output",
#    use_device = TRUE
#  )
#  
#  lm.D9 <- slack_lm(weight ~ group)
#  
#  # clean up slack channel from examples
#  delete_slackr(count = 6, channel = "#general")

