% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_league_streaks_table.R
\name{plot_league_streaks_table}
\alias{plot_league_streaks_table}
\title{Plot League Streaks Table}
\usage{
plot_league_streaks_table(
  league_id,
  font_color = "inherit",
  win_streak_font_color = "lightgreen",
  lose_streak_font_color = "#f68383"
)
}
\arguments{
\item{league_id}{League ID generated from Sleeper (numeric).}

\item{font_color}{Header font color, hex code or name (string).}

\item{win_streak_font_color}{Font color, hex code or name, for teams with winning streak (string).}

\item{lose_streak_font_color}{Font color, hex code or name, for teams with losing streak (string).}
}
\value{
Returns a table containing display names and their streaks.
}
\description{
Given the league ID, generate a table showing display names
and their associated streaks (2W, 5L, etc.).
}
\examples{
\dontrun{plot_league_streaks_table(688281863499907072)}
\dontrun{plot_league_streaks_table(688281863499907072, font_color = "red")}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, January 2024
}
\keyword{information}
\keyword{league}
\keyword{statistics}
