% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_phylo}
\alias{ts_phylo}
\title{Convert a tree in the tree sequence to an object of the class \code{phylo}}
\usage{
ts_phylo(
  ts,
  i,
  mode = c("index", "position"),
  labels = c("tskit", "pop"),
  quiet = FALSE
)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{i}{Position of the tree in the tree sequence. If \code{mode = "index"},
an i-th tree will be returned (in zero-based indexing as in tskit), if
\code{mode = "position"}, a tree covering the i-th base of the simulated genome will be
returned (again, in tskit's indexing).}

\item{mode}{How should the \code{i} argument be interpreted? Either "index"
as an i-th tree in the sequence of genealogies, or "position" along the
simulated genome.}

\item{labels}{What should be stored as node labels in the final \code{phylo}
object? Options are either a population name or a tskit integer node ID
(which is a different thing from a \code{phylo} class node integer index).}

\item{quiet}{Should ape's internal phylo validity test be printed out?}
}
\value{
Standard phylogenetic tree object implemented by the R package ape
}
\description{
Convert a tree in the tree sequence to an object of the class \code{phylo}
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model) \%>\%
  ts_recapitate(Ne = 10000, recombination_rate = 1e-8) \%>\%
  ts_simplify()

# extract the 1st tree from a given tree sequence, return ape object
tree <- ts_phylo(ts, i = 1, mode = "index", quiet = TRUE)
tree

# extract the tree at a 42th basepair in the given tree sequence
tree <- ts_phylo(ts, i = 42, mode = "position", quiet = TRUE)

# because the tree is a standard ape phylo object, we can plot it easily
plot(tree, use.edge.length = FALSE)
ape::nodelabels()
}
