% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generative.R
\name{generative_process}
\alias{generative_process}
\title{Some stationary processes}
\usage{
generative_process(n, process = "AR1", phi = "numeric",
  theta = "numeric")
}
\arguments{
\item{n}{sample size.}

\item{process}{a list of character to choose the process.}

\item{phi}{a numeric vector with AR parameters if the process is "AR1" or "AR12".}

\item{theta}{a numeric vector with MA parameters if the process is "MA12".}
}
\value{
This function returns a vector of observations drawn according to the selected process.
}
\description{
This is a generative function. The user chooses one of the \code{process}: "AR1", "AR12", "MA12", "Nonmixing", "sysdyn", and it
 generates the chosen process. These processes are fully described in the paper of
 E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
\examples{
generative_process(200,"Nonmixing")
}
\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
